/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import java.util.regex.Matcher;
import org.jscsi.target.settings.NumericalValue;

public final class SingleNumericalValue
extends NumericalValue {
    private final int value;

    private SingleNumericalValue(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public static final SingleNumericalValue create(int value) {
        return new SingleNumericalValue(value);
    }

    public static final SingleNumericalValue parseSingleNumericValue(String value) {
        Matcher decimalMatcher = DECIMAL_CONSTANT_PATTERN.matcher(value);
        if (decimalMatcher.matches()) {
            return new SingleNumericalValue(SingleNumericalValue.parseDecimalConstantString(value));
        }
        Matcher hexMatcher = HEX_CONSTANT_PATTERN.matcher(value);
        if (hexMatcher.matches()) {
            return new SingleNumericalValue(SingleNumericalValue.parseHexConstantString(value));
        }
        Matcher base64Matcher = BASE_64_CONSTANT_PATTERN.matcher(value);
        if (base64Matcher.matches()) {
            return new SingleNumericalValue(SingleNumericalValue.parseBase64ConstantString(value));
        }
        return null;
    }

    private static final int parseDecimalConstantString(String value) {
        return Integer.valueOf(value);
    }

    private static final int parseHexConstantString(String value) {
        return Integer.parseInt(value.substring(2), 16);
    }

    private static final int parseBase64ConstantString(String value) {
        String s = value.substring(2);
        int length = s.length();
        int result = 0;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(length - 1 - i);
            result = (int)((double)result + (double)SingleNumericalValue.base64ValueOf(c) * Math.pow(64.0, i));
        }
        return result;
    }

    private static final int base64ValueOf(char c) {
        if ('A' <= c && c <= 'Z') {
            return c - 65;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 26;
        }
        if ('0' <= c && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new NumberFormatException();
    }

    public final String toString() {
        return "[" + this.value + "]";
    }

    @Override
    public boolean contains(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof SingleNumericalValue) {
            return this.contains(((SingleNumericalValue)value).getValue());
        }
        if (value instanceof Integer) {
            return this.contains((Integer)value);
        }
        return false;
    }

    @Override
    public boolean contains(int value) {
        return value == this.value;
    }
}

