/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jscsi.target.settings.TextKeyword;

public final class TextParameter {
    private static final Pattern TEXT_VALUE_PATTERN = Pattern.compile("[\\[\\]a-zA-Z0-9.:;_@/+-]+");

    private TextParameter() {
    }

    public static List<String> tokenizeKeyValuePairs(String keyValuePairs) {
        Vector<String> result = new Vector<String>();
        if (keyValuePairs == null) {
            return result;
        }
        String[] split = keyValuePairs.split(TextKeyword.NULL_CHAR);
        for (int i = 0; i < split.length; ++i) {
            if (split[i].length() <= 0) continue;
            result.add(split[i]);
        }
        return result;
    }

    public static String concatenateKeyValuePairs(Collection<String> keyValuePairs) {
        StringBuilder sb = new StringBuilder();
        for (String s : keyValuePairs) {
            sb.append(s);
            sb.append(TextKeyword.NULL_CHAR);
        }
        return sb.toString();
    }

    public static String getSuffix(String string, String prefix) {
        if (string == null || prefix == null || prefix.length() > string.length()) {
            return null;
        }
        String stringPrefix = string.substring(0, prefix.length());
        if (stringPrefix.equals(prefix)) {
            return string.substring(prefix.length());
        }
        return null;
    }

    public static String[] splitKeyValuePair(String keyValuePair) {
        String[] split = keyValuePair.split("=");
        if (split.length != 2 || split[0].length() == 0 || split[1].length() == 0) {
            return null;
        }
        return split;
    }

    public static String[] splitValues(String values) {
        if (values == null) {
            return null;
        }
        return values.split(",");
    }

    public static String[] intersect(String[] a, String[] b) {
        if (a == null || b == null) {
            return null;
        }
        int maxLength = Math.max(a.length, b.length);
        ArrayList<String> intersection = new ArrayList<String>(maxLength);
        block0: for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (a[i] == null || b[j] == null) {
                    return null;
                }
                if (!a[i].matches(b[j])) continue;
                intersection.add(a[i]);
                continue block0;
            }
        }
        String[] result = new String[intersection.size()];
        result = intersection.toArray(result);
        return result;
    }

    public static Boolean parseBooleanValue(String value) {
        if (value == null) {
            return null;
        }
        if ("Yes".equals(value)) {
            return true;
        }
        if ("No".equals(value)) {
            return false;
        }
        return null;
    }

    public static boolean checkTextValueFormat(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = TEXT_VALUE_PATTERN.matcher(value);
        return matcher.matches();
    }

    public static String toKeyValuePair(String key, String value) {
        return key + "=" + value;
    }

    public static String booleanToTextValue(boolean value) {
        if (value) {
            return "Yes";
        }
        return "No";
    }
}

