/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings.entry;

import org.jscsi.target.TargetServer;
import org.jscsi.target.settings.BooleanResultFunction;
import org.jscsi.target.settings.KeySet;
import org.jscsi.target.settings.NegotiationStatus;
import org.jscsi.target.settings.NegotiationType;
import org.jscsi.target.settings.TextParameter;
import org.jscsi.target.settings.entry.Entry;
import org.jscsi.target.settings.entry.Use;

public final class BooleanEntry
extends Entry {
    private final boolean negotiationValue;
    private final BooleanResultFunction resultFunction;

    public BooleanEntry(KeySet keySet, Use use, NegotiationStatus negotiationStatus, boolean negotiationValue, BooleanResultFunction resultFunction, Boolean defaultValue) {
        super(keySet, NegotiationType.NEGOTIATED, use, negotiationStatus, defaultValue);
        this.negotiationValue = negotiationValue;
        this.resultFunction = resultFunction;
    }

    @Override
    protected Object parseOffer(TargetServer target, String values) {
        return TextParameter.parseBooleanValue(values);
    }

    @Override
    protected boolean inProtocolValueRange(Object values) {
        return values instanceof Boolean;
    }

    @Override
    protected void processDeclaration(Object values) {
    }

    @Override
    protected String processNegotiation(Object values) {
        boolean request = (Boolean)values;
        boolean result = this.resultFunction.getResult(request, this.negotiationValue);
        this.value = result;
        return TextParameter.booleanToTextValue(result);
    }

    @Override
    public Boolean getBooleanValue() {
        return (Boolean)this.value;
    }

    @Override
    public Entry copy() {
        BooleanEntry e = new BooleanEntry(this.keySet, this.use, this.negotiationStatus, this.negotiationValue, this.resultFunction, (Boolean)this.value);
        e.alreadyNegotiated = this.alreadyNegotiated;
        return e;
    }
}

