/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings.entry;

import java.util.Collection;
import javax.naming.OperationNotSupportedException;
import org.jscsi.parser.login.LoginStage;
import org.jscsi.target.TargetServer;
import org.jscsi.target.settings.KeySet;
import org.jscsi.target.settings.NegotiationStatus;
import org.jscsi.target.settings.NegotiationType;
import org.jscsi.target.settings.TextParameter;
import org.jscsi.target.settings.entry.Use;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Entry {
    private static final Logger LOGGER = LoggerFactory.getLogger(Entry.class);
    protected final KeySet keySet;
    protected final NegotiationType negotiationType;
    protected final Use use;
    protected NegotiationStatus negotiationStatus;
    protected Object value;
    protected boolean alreadyNegotiated = false;

    public Entry(KeySet keySet, NegotiationType negotiationType, Use use, NegotiationStatus negotiationStatus, Object defaultValue) {
        this.keySet = keySet;
        this.negotiationType = negotiationType;
        this.use = use;
        this.negotiationStatus = negotiationStatus;
        this.value = defaultValue;
    }

    private void fail(String logMessage) {
        LOGGER.error("negotiation error " + this.keySet + ": " + logMessage);
        this.negotiationStatus = NegotiationStatus.REJECTED;
    }

    protected abstract Object parseOffer(TargetServer var1, String var2);

    public final boolean negotiate(TargetServer target, LoginStage loginStage, boolean leadingConnection, boolean initialPdu, String key, String values, Collection<String> responseKeyValuePairs) {
        if (!this.matchKey(key)) {
            this.fail("\"" + key + "\" does not match key in" + this.keySet);
            return false;
        }
        if (this.alreadyNegotiated) {
            this.fail("illegal renegotiation");
            return false;
        }
        this.alreadyNegotiated = true;
        if (!this.use.checkUse(loginStage, leadingConnection, initialPdu)) {
            this.fail("wrong use: " + (Object)((Object)this.use) + ", " + loginStage + ", " + leadingConnection + ", " + initialPdu);
            return false;
        }
        Object offer = this.parseOffer(target, values);
        if (offer == null) {
            this.fail("value format error: " + values);
            return false;
        }
        if (!this.inProtocolValueRange(offer)) {
            this.fail("illegal values offered: " + values);
            return false;
        }
        if (this.negotiationType == NegotiationType.DECLARED) {
            this.processDeclaration(offer);
            this.negotiationStatus = NegotiationStatus.ACCEPTED;
            return true;
        }
        if (this.negotiationType == NegotiationType.NEGOTIATED) {
            String negotiatedValue = this.negotiationStatus == NegotiationStatus.IRRELEVANT ? "Irrelevant" : this.processNegotiation(offer);
            if (negotiatedValue == null) {
                String reply = TextParameter.toKeyValuePair(key, "Reject");
                responseKeyValuePairs.add(reply);
                this.fail("rejected value(s): " + values);
                return false;
            }
            String reply = TextParameter.toKeyValuePair(key, negotiatedValue);
            responseKeyValuePairs.add(reply);
            return true;
        }
        this.fail("initialization error: negotiationType == null");
        return false;
    }

    public void resetAlreadyNegotiated() {
        this.alreadyNegotiated = false;
    }

    public Boolean getBooleanValue() throws OperationNotSupportedException {
        throw new OperationNotSupportedException();
    }

    public Integer getIntegerValue() throws OperationNotSupportedException {
        throw new OperationNotSupportedException();
    }

    public String getStringValue() throws OperationNotSupportedException {
        throw new OperationNotSupportedException();
    }

    public final boolean matchKey(String key) {
        return this.keySet.matchKey(key);
    }

    protected abstract boolean inProtocolValueRange(Object var1);

    protected abstract void processDeclaration(Object var1);

    protected abstract String processNegotiation(Object var1);

    public final NegotiationStatus getNegotiationStatus() {
        return this.negotiationStatus;
    }

    public abstract Entry copy();

    public boolean checkAccepted() {
        return this.negotiationStatus == NegotiationStatus.ACCEPTED;
    }
}

