/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings.entry;

import org.jscsi.target.TargetServer;
import org.jscsi.target.settings.KeySet;
import org.jscsi.target.settings.NegotiationStatus;
import org.jscsi.target.settings.NegotiationType;
import org.jscsi.target.settings.NumericalResultFunction;
import org.jscsi.target.settings.NumericalValueRange;
import org.jscsi.target.settings.SingleNumericalValue;
import org.jscsi.target.settings.entry.Entry;
import org.jscsi.target.settings.entry.Use;

public final class NumericalEntry
extends Entry {
    private final NumericalValueRange protocolValueRange;
    private final int negotiationValue;
    private final NumericalResultFunction resultFunction;
    private final boolean zeroMeansDontCare;

    public NumericalEntry(KeySet keySet, NegotiationType negotiationType, Use use, NegotiationStatus negotiationStatus, int negotiationValue, NumericalValueRange protocolValueRange, NumericalResultFunction resultFunction, Integer defaultValue, boolean zeroMeansDontCare) {
        super(keySet, negotiationType, use, negotiationStatus, defaultValue);
        this.protocolValueRange = protocolValueRange;
        this.negotiationValue = negotiationValue;
        this.resultFunction = resultFunction;
        this.zeroMeansDontCare = zeroMeansDontCare;
    }

    @Override
    protected boolean inProtocolValueRange(Object values) {
        int val = (Integer)values;
        if (this.zeroMeansDontCare && val == 0) {
            return true;
        }
        return this.protocolValueRange.contains(val);
    }

    @Override
    protected Object parseOffer(TargetServer target, String values) {
        return SingleNumericalValue.parseSingleNumericValue(values).getValue();
    }

    @Override
    protected void processDeclaration(Object values) {
        int val = (Integer)values;
        this.value = this.zeroMeansDontCare && val == 0 ? Integer.valueOf(this.negotiationValue) : values;
    }

    @Override
    protected String processNegotiation(Object values) {
        int val = (Integer)values;
        this.value = this.zeroMeansDontCare && val == 0 ? Integer.valueOf(this.negotiationValue) : Integer.valueOf(this.resultFunction.getResult(this.negotiationValue, val));
        return this.value.toString();
    }

    @Override
    public Integer getIntegerValue() {
        return (Integer)this.value;
    }

    @Override
    public Entry copy() {
        NumericalEntry e = new NumericalEntry(this.keySet, this.negotiationType, this.use, this.negotiationStatus, this.negotiationValue, this.protocolValueRange, this.resultFunction, (Integer)this.value, this.zeroMeansDontCare);
        e.alreadyNegotiated = this.alreadyNegotiated;
        return e;
    }
}

