/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings.entry;

import org.jscsi.target.TargetServer;
import org.jscsi.target.settings.KeySet;
import org.jscsi.target.settings.NegotiationStatus;
import org.jscsi.target.settings.NegotiationType;
import org.jscsi.target.settings.NumericalValueRange;
import org.jscsi.target.settings.SingleNumericalValue;
import org.jscsi.target.settings.entry.Entry;
import org.jscsi.target.settings.entry.Use;

public final class NumericalRangeEntry
extends Entry {
    private final NumericalValueRange protocolValueRange;
    private final int negotiationValue;

    public NumericalRangeEntry(KeySet keySet, Use use, NegotiationStatus negotiationStatus, int negotiationValue, NumericalValueRange protocolValueRange, Object defaultValue) {
        super(keySet, NegotiationType.NEGOTIATED, use, negotiationStatus, defaultValue);
        this.negotiationValue = negotiationValue;
        this.protocolValueRange = protocolValueRange;
    }

    @Override
    protected boolean inProtocolValueRange(Object values) {
        return this.protocolValueRange.contains((NumericalValueRange)values);
    }

    @Override
    protected Object parseOffer(TargetServer target, String values) {
        SingleNumericalValue singleValue;
        NumericalValueRange range = NumericalValueRange.parseNumericalValueRange(values);
        if (range == null && target.getConfig().getAllowSloppyNegotiation() && (singleValue = SingleNumericalValue.parseSingleNumericValue(values)) != null) {
            range = NumericalValueRange.create(singleValue.getValue(), singleValue.getValue());
        }
        return range;
    }

    @Override
    protected void processDeclaration(Object values) {
    }

    @Override
    protected String processNegotiation(Object values) {
        NumericalValueRange range = (NumericalValueRange)values;
        if (range.contains(this.negotiationValue)) {
            this.value = this.negotiationValue;
            return this.value.toString();
        }
        this.value = null;
        return null;
    }

    @Override
    public Integer getIntegerValue() {
        return (Integer)this.value;
    }

    @Override
    public Entry copy() {
        NumericalRangeEntry e = new NumericalRangeEntry(this.keySet, this.use, this.negotiationStatus, this.negotiationValue, this.protocolValueRange, (Integer)this.value);
        e.alreadyNegotiated = this.alreadyNegotiated;
        return e;
    }
}

