/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings.entry;

import org.jscsi.target.TargetServer;
import org.jscsi.target.settings.KeySet;
import org.jscsi.target.settings.NegotiationStatus;
import org.jscsi.target.settings.NegotiationType;
import org.jscsi.target.settings.TextParameter;
import org.jscsi.target.settings.entry.Entry;
import org.jscsi.target.settings.entry.Use;

public final class StringEntry
extends Entry {
    private final String[] supportedValues;

    public StringEntry(KeySet keySet, NegotiationType negotiationType, Use use, NegotiationStatus negotiationStatus, String[] supportedValues, Object defaultValue) {
        super(keySet, negotiationType, use, negotiationStatus, defaultValue);
        this.supportedValues = supportedValues;
    }

    @Override
    protected boolean inProtocolValueRange(Object values) {
        String[] vals;
        for (String s : vals = (String[])values) {
            if (TextParameter.checkTextValueFormat(s)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object parseOffer(TargetServer target, String values) {
        String[] split = TextParameter.splitValues(values);
        if (this.negotiationType == NegotiationType.DECLARED && split.length > 1) {
            return null;
        }
        return split;
    }

    @Override
    protected void processDeclaration(Object values) {
        this.value = ((String[])values)[0];
    }

    @Override
    protected String processNegotiation(Object values) {
        String[] requestedValues = (String[])values;
        String[] commonValues = TextParameter.intersect(this.supportedValues, requestedValues);
        if (commonValues.length == 0) {
            return null;
        }
        this.value = commonValues[0];
        return commonValues[0];
    }

    @Override
    public String getStringValue() {
        return (String)this.value;
    }

    @Override
    public Entry copy() {
        StringEntry e = new StringEntry(this.keySet, this.negotiationType, this.use, this.negotiationStatus, this.supportedValues, (String)this.value);
        e.alreadyNegotiated = this.alreadyNegotiated;
        return e;
    }
}

