/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.settings.entry;

import org.jscsi.parser.login.LoginStage;

public enum Use {
    LEADING_LOPNS,
    LOPNS,
    LOPNS_AND_FFP,
    FFP,
    INITIAL,
    INITIAL_AND_FFP;


    private static boolean checkUse(Use use, LoginStage loginStage, boolean leadingConnection, boolean initialPdu) {
        switch (use) {
            case LEADING_LOPNS: {
                return leadingConnection && loginStage == LoginStage.LOGIN_OPERATIONAL_NEGOTIATION;
            }
            case LOPNS: {
                return loginStage == LoginStage.LOGIN_OPERATIONAL_NEGOTIATION;
            }
            case LOPNS_AND_FFP: {
                return loginStage == LoginStage.LOGIN_OPERATIONAL_NEGOTIATION || loginStage == LoginStage.FULL_FEATURE_PHASE;
            }
            case FFP: {
                return loginStage == LoginStage.FULL_FEATURE_PHASE;
            }
            case INITIAL_AND_FFP: {
                if (initialPdu && loginStage == LoginStage.FULL_FEATURE_PHASE) {
                    return true;
                }
            }
            case INITIAL: {
                return initialPdu && (loginStage == LoginStage.SECURITY_NEGOTIATION || loginStage == LoginStage.LOGIN_OPERATIONAL_NEGOTIATION);
            }
        }
        return false;
    }

    public boolean checkUse(LoginStage loginStage, boolean leadingConnection, boolean initialPdu) {
        return Use.checkUse(this, loginStage, leadingConnection, initialPdu);
    }
}

