/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.jscsi.target.storage.IStorageModule;

@Deprecated
public class FileStorageModule
implements IStorageModule {
    private final String mBaseDir;
    private final long mStorageSize;
    private final int mFileSize;
    private Cache<Integer, byte[]> mCache;
    private final int CACHE_SIZE;
    private static final int VIRTUAL_BLOCK_SIZE = 512;

    public FileStorageModule(String pBaseDir, long pStorageSize, int pFileSize) throws IOException {
        this.mBaseDir = pBaseDir;
        this.mFileSize = pFileSize;
        this.mStorageSize = pStorageSize;
        this.CACHE_SIZE = 0x10000000 / pFileSize;
        File file = new File(pBaseDir);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            throw new IOException("The parameter pBaseDir does not seem to be a directory.");
        }
        this.mCache = CacheBuilder.newBuilder().maximumSize((long)this.CACHE_SIZE).build();
    }

    @Override
    public void read(byte[] bytes, long storageIndex) throws IOException {
        long filePos = storageIndex / (long)this.mFileSize;
        int storageOffset = (int)(storageIndex % (long)this.mFileSize);
        byte[] cachedBytes = (byte[])this.mCache.getIfPresent((Object)filePos);
        File fileAtPos = new File(this.mBaseDir + File.separator + filePos);
        if (!fileAtPos.exists()) {
            fileAtPos.createNewFile();
            cachedBytes = new byte[this.mFileSize];
            Files.write(fileAtPos.toPath(), cachedBytes, new OpenOption[0]);
        } else if (cachedBytes == null) {
            cachedBytes = Files.readAllBytes(fileAtPos.toPath());
            this.mCache.put((Object)((int)filePos), (Object)cachedBytes);
        }
        if (storageOffset + bytes.length > this.mFileSize) {
            System.arraycopy(cachedBytes, storageOffset, bytes, 0, this.mFileSize - storageOffset);
            byte[] nextStep = new byte[bytes.length - (this.mFileSize - storageOffset)];
            this.read(nextStep, storageIndex + (long)(this.mFileSize - storageOffset));
            System.arraycopy(nextStep, 0, bytes, this.mFileSize - storageOffset, nextStep.length);
        } else {
            System.arraycopy(cachedBytes, storageOffset, bytes, 0, bytes.length);
        }
    }

    @Override
    public void write(byte[] bytes, long storageIndex) throws IOException {
        long filePos = storageIndex / (long)this.mFileSize;
        boolean cached = true;
        int storageOffset = (int)(storageIndex % (long)this.mFileSize);
        byte[] cachedBytes = (byte[])this.mCache.getIfPresent((Object)filePos);
        File fileAtPos = new File(this.mBaseDir + File.separator + filePos);
        if (!fileAtPos.exists()) {
            fileAtPos.createNewFile();
            cachedBytes = new byte[this.mFileSize];
        } else if (cachedBytes == null) {
            cachedBytes = Files.readAllBytes(fileAtPos.toPath());
            cached = false;
        }
        if (storageOffset + bytes.length > this.mFileSize) {
            System.arraycopy(bytes, 0, cachedBytes, storageOffset, this.mFileSize - storageOffset);
            Files.write(new File(this.mBaseDir + File.separator + filePos).toPath(), cachedBytes, new OpenOption[0]);
            byte[] nextStep = new byte[bytes.length - (this.mFileSize - storageOffset)];
            System.arraycopy(bytes, this.mFileSize - storageOffset, nextStep, 0, bytes.length - (this.mFileSize - storageOffset));
            this.write(nextStep, storageIndex + (long)(this.mFileSize - storageOffset));
        } else {
            System.arraycopy(bytes, 0, cachedBytes, storageOffset, bytes.length);
            Files.write(fileAtPos.toPath(), cachedBytes, new OpenOption[0]);
        }
        if (!cached) {
            this.mCache.put((Object)((int)filePos), (Object)cachedBytes);
        }
    }

    @Override
    public int checkBounds(long logicalBlockAddress, int transferLengthInBlocks) {
        if (logicalBlockAddress < 0L || logicalBlockAddress >= this.getSizeInBlocks()) {
            return 1;
        }
        if (transferLengthInBlocks < 0 || logicalBlockAddress + (long)transferLengthInBlocks > this.getSizeInBlocks()) {
            return 2;
        }
        return 0;
    }

    @Override
    public long getSizeInBlocks() {
        return this.mStorageSize / 512L;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int getBlockSize() {
        return 512;
    }
}

