/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.storage;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.domain.Location;
import org.jscsi.target.storage.IStorageModule;

@Beta
public class JCloudsStorageModule
implements IStorageModule {
    public static final int BLOCK_IN_CLUSTER = 512;
    private static final int BUCKETS_TO_PREFETCH = 3;
    private static final boolean ENCRYPT = false;
    private static final String ALGO = "AES";
    private static byte[] keyValue = new byte[]{107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107};
    private static final Key KEY = new SecretKeySpec(keyValue, "AES");
    private static final int VIRTUAL_BLOCK_SIZE = 512;
    public static final int SIZE_PER_BUCKET = 262144;
    public static final String CONTAINERNAME = "bench53473ResourcegraveISCSI9284";
    private final long mNumberOfCluster;
    private final String mContainerName;
    private final BlobStore mStore;
    private final BlobStoreContext mContext;
    private final Cache<Integer, byte[]> mByteCache;
    private int lastIndexWritten;
    private byte[] lastBlobWritten;
    private final CompletionService<Integer> mWriterService;
    private final CompletionService<Map.Entry<Integer, byte[]>> mReaderService;
    private final ConcurrentHashMap<Integer, Future<Integer>> mRunningWriteTasks;
    private final ConcurrentHashMap<Integer, Future<Map.Entry<Integer, byte[]>>> mRunningReadTasks;

    public JCloudsStorageModule(long pSizeInBlocks, File pFile) {
        this.mNumberOfCluster = 2048L;
        this.mContainerName = CONTAINERNAME;
        String[] credentials = JCloudsStorageModule.getCredentials();
        if (credentials.length == 0) {
            Properties properties = new Properties();
            properties.setProperty("jclouds.filesystem.basedir", pFile.getAbsolutePath());
            this.mContext = (BlobStoreContext)ContextBuilder.newBuilder((String)"filesystem").overrides(properties).credentials("testUser", "testPass").buildView(BlobStoreContext.class);
        } else {
            this.mContext = (BlobStoreContext)ContextBuilder.newBuilder((String)"aws-s3").credentials(JCloudsStorageModule.getCredentials()[0], JCloudsStorageModule.getCredentials()[1]).buildView(BlobStoreContext.class);
        }
        this.mStore = this.mContext.getBlobStore();
        if (!this.mStore.containerExists(this.mContainerName)) {
            Location locToSet = null;
            for (Location loc : this.mStore.listAssignableLocations()) {
                if (!loc.getId().equals("eu-west-1")) continue;
                locToSet = loc;
                break;
            }
            this.mStore.createContainerInLocation(locToSet, this.mContainerName);
        }
        ExecutorService writerService = Executors.newFixedThreadPool(20);
        ExecutorService readerService = Executors.newFixedThreadPool(20);
        this.mRunningWriteTasks = new ConcurrentHashMap();
        this.mRunningReadTasks = new ConcurrentHashMap();
        this.mReaderService = new ExecutorCompletionService<Map.Entry<Integer, byte[]>>(readerService);
        Thread readHashmapCleaner = new Thread(new ReadFutureCleaner());
        readHashmapCleaner.setDaemon(true);
        readHashmapCleaner.start();
        this.mWriterService = new ExecutorCompletionService<Integer>(writerService);
        Thread writeHashmapCleaner = new Thread(new WriteFutureCleaner());
        writeHashmapCleaner.setDaemon(true);
        writeHashmapCleaner.start();
        this.mByteCache = CacheBuilder.newBuilder().maximumSize(100L).build();
        this.lastIndexWritten = -1;
    }

    @Override
    public int checkBounds(long logicalBlockAddress, int transferLengthInBlocks) {
        if (logicalBlockAddress < 0L || logicalBlockAddress >= this.getSizeInBlocks()) {
            return 1;
        }
        if (transferLengthInBlocks < 0 || logicalBlockAddress + (long)transferLengthInBlocks > this.getSizeInBlocks()) {
            return 2;
        }
        return 0;
    }

    @Override
    public long getSizeInBlocks() {
        return this.mNumberOfCluster * 512L;
    }

    @Override
    public synchronized void read(byte[] bytes, long storageIndex) throws IOException {
        int bucketIndex = (int)(storageIndex / 262144L);
        int bucketOffset = (int)(storageIndex % 262144L);
        try {
            this.storeBucket(-1, null);
            byte[] data = (byte[])this.mByteCache.getIfPresent((Object)bucketIndex);
            if (data == null) {
                data = this.getAndprefetchBuckets(bucketIndex);
            }
            ByteArrayDataOutput output = ByteStreams.newDataOutput((int)bytes.length);
            int length = bucketOffset + bytes.length > 262144 ? 262144 - bucketOffset : bytes.length;
            output.write(data, bucketOffset, length);
            if (bucketOffset + bytes.length > 262144) {
                data = (byte[])this.mByteCache.getIfPresent((Object)(bucketIndex + 1));
                if (data == null) {
                    data = this.getAndprefetchBuckets(bucketIndex + 1);
                }
                output.write(data, 0, bytes.length - (262144 - bucketOffset));
            }
            System.arraycopy(output.toByteArray(), 0, bytes, 0, bytes.length);
        }
        catch (InterruptedException | ExecutionException exc) {
            throw new IOException(exc);
        }
    }

    private final byte[] getAndprefetchBuckets(int pBucketStartId) throws InterruptedException, ExecutionException {
        Future<Map.Entry<Integer, byte[]>> startTask = null;
        for (int i = pBucketStartId; i < pBucketStartId + 3; ++i) {
            Future<Map.Entry<Integer, byte[]>> currentTask = this.mRunningReadTasks.remove(i);
            if (currentTask == null) {
                currentTask = this.mReaderService.submit(new ReadTask(i));
                this.mRunningReadTasks.put(i, currentTask);
            }
            if (i != pBucketStartId) continue;
            startTask = currentTask;
        }
        byte[] returnval = (byte[])((Map.Entry)startTask.get()).getValue();
        return returnval;
    }

    private final void storeBucket(int pBucketId, byte[] pData) throws InterruptedException, ExecutionException {
        if (this.lastIndexWritten != pBucketId && this.lastBlobWritten != null) {
            Future<Integer> writeTask = this.mRunningWriteTasks.remove(this.lastIndexWritten);
            if (writeTask != null) {
                writeTask.cancel(false);
            }
            this.mRunningWriteTasks.put(this.lastIndexWritten, this.mWriterService.submit(new WriteTask(this.lastBlobWritten, this.lastIndexWritten)));
        }
        this.lastIndexWritten = pBucketId;
        this.lastBlobWritten = pData;
    }

    @Override
    public synchronized void write(byte[] bytes, long storageIndex) throws IOException {
        int bucketIndex = (int)(storageIndex / 262144L);
        int bucketOffset = (int)(storageIndex % 262144L);
        try {
            byte[] data = (byte[])this.mByteCache.getIfPresent((Object)bucketIndex);
            if (data == null) {
                data = this.getAndprefetchBuckets(bucketIndex);
            }
            System.arraycopy(bytes, 0, data, bucketOffset, bytes.length + bucketOffset > 262144 ? 262144 - bucketOffset : bytes.length);
            this.storeBucket(bucketIndex, data);
            this.mByteCache.put((Object)bucketIndex, (Object)data);
            if (bucketOffset + bytes.length > 262144) {
                data = (byte[])this.mByteCache.getIfPresent((Object)(bucketIndex + 1));
                if (data == null) {
                    data = this.getAndprefetchBuckets(bucketIndex + 1);
                }
                System.arraycopy(bytes, 262144 - bucketOffset, data, 0, bytes.length - (262144 - bucketOffset));
                this.storeBucket(bucketIndex + 1, data);
                this.mByteCache.put((Object)(bucketIndex + 1), (Object)data);
            }
        }
        catch (InterruptedException | ExecutionException exc) {
            throw new IOException(exc);
        }
    }

    @Override
    public void close() throws IOException {
        this.mContext.close();
    }

    @Override
    public int getBlockSize() {
        return 512;
    }

    private static String[] getCredentials() {
        return new String[0];
    }

    class WriteFutureCleaner
    extends Thread {
        WriteFutureCleaner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Future element;
                    if ((element = JCloudsStorageModule.this.mWriterService.take()).isCancelled()) {
                        continue;
                    }
                    JCloudsStorageModule.this.mRunningWriteTasks.remove(element.get());
                }
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    class ReadFutureCleaner
    extends Thread {
        ReadFutureCleaner() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Future element;
                    if ((element = JCloudsStorageModule.this.mReaderService.take()).isCancelled()) {
                        continue;
                    }
                    JCloudsStorageModule.this.mRunningReadTasks.remove(((Map.Entry)element.get()).getKey());
                }
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    class WriteTask
    implements Callable<Integer> {
        final byte[] mData;
        final int mBucketIndex;
        final Cipher mCipher;

        WriteTask(byte[] pData, int pBucketIndex) {
            Preconditions.checkState((pData.length == 262144 ? 1 : 0) != 0);
            this.mCipher = null;
            this.mData = pData;
            this.mBucketIndex = pBucketIndex;
        }

        @Override
        public Integer call() throws Exception {
            boolean finished = false;
            while (!finished) {
                try {
                    byte[] data = this.mData;
                    Blob blob = JCloudsStorageModule.this.mStore.blobBuilder(Integer.toString(this.mBucketIndex)).build();
                    blob.setPayload(data);
                    JCloudsStorageModule.this.mStore.putBlob(JCloudsStorageModule.this.mContainerName, blob);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                finished = true;
            }
            return this.mBucketIndex;
        }
    }

    class ReadTask
    implements Callable<Map.Entry<Integer, byte[]>> {
        final Cipher mCipher = null;
        final int mBucketId;

        ReadTask(int pBucketId) {
            this.mBucketId = pBucketId;
        }

        @Override
        public Map.Entry<Integer, byte[]> call() throws Exception {
            byte[] data = (byte[])JCloudsStorageModule.this.mByteCache.getIfPresent((Object)this.mBucketId);
            if (data == null) {
                Blob blob = JCloudsStorageModule.this.mStore.getBlob(JCloudsStorageModule.this.mContainerName, Integer.toString(this.mBucketId));
                if (blob == null) {
                    data = new byte[262144];
                } else {
                    try (InputStream is = blob.getPayload().getInput();){
                        data = ByteStreams.toByteArray((InputStream)is);
                    }
                    while (data.length < 262144) {
                        blob = JCloudsStorageModule.this.mStore.getBlob(JCloudsStorageModule.this.mContainerName, Integer.toString(this.mBucketId));
                        is = blob.getPayload().getInput();
                        var4_4 = null;
                        try {
                            data = ByteStreams.toByteArray((InputStream)is);
                        }
                        catch (Throwable throwable) {
                            var4_4 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is == null) continue;
                            if (var4_4 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    var4_4.addSuppressed(throwable);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                }
            }
            if (data.length < 262144) {
                System.out.println(data.length);
            }
            JCloudsStorageModule.this.mByteCache.put((Object)this.mBucketId, (Object)data);
            final byte[] finalizedData = data;
            return new Map.Entry<Integer, byte[]>(){

                @Override
                public byte[] setValue(byte[] value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public byte[] getValue() {
                    return finalizedData;
                }

                @Override
                public Integer getKey() {
                    return ReadTask.this.mBucketId;
                }
            };
        }
    }
}

