/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import org.jscsi.target.storage.IStorageModule;
import org.jscsi.target.storage.JCloudsStorageModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomAccessStorageModule
implements IStorageModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomAccessStorageModule.class);
    private static final int VIRTUAL_BLOCK_SIZE = 512;
    private static final String MODE = "rwd";
    protected final long sizeInBlocks;
    private final RandomAccessFile randomAccessFile;

    public RandomAccessStorageModule(long sizeInBlocks, File file) throws FileNotFoundException {
        this.sizeInBlocks = sizeInBlocks;
        this.randomAccessFile = new RandomAccessFile(file, MODE);
    }

    @Override
    public void read(byte[] bytes, long storageIndex) throws IOException {
        this.randomAccessFile.seek(storageIndex);
        this.randomAccessFile.read(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, long storageIndex) throws IOException {
        this.randomAccessFile.seek(storageIndex);
        this.randomAccessFile.write(bytes, 0, bytes.length);
    }

    @Override
    public final long getSizeInBlocks() {
        return this.sizeInBlocks;
    }

    @Override
    public final int checkBounds(long logicalBlockAddress, int transferLengthInBlocks) {
        if (logicalBlockAddress < 0L || logicalBlockAddress >= this.sizeInBlocks) {
            return 1;
        }
        if (transferLengthInBlocks < 0 || logicalBlockAddress + (long)transferLengthInBlocks > this.sizeInBlocks) {
            return 2;
        }
        return 0;
    }

    @Override
    public final void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public int getBlockSize() {
        return 512;
    }

    public static final synchronized IStorageModule open(File file, long storageLength, boolean create, Class<? extends IStorageModule> kind) throws IOException {
        long sizeInBlocks = storageLength / 512L;
        if (create && !kind.equals(JCloudsStorageModule.class)) {
            RandomAccessStorageModule.createStorageVolume(file, storageLength);
        }
        Constructor<?> cons = kind.getConstructors()[0];
        try {
            IStorageModule mod = (IStorageModule)cons.newInstance(sizeInBlocks, file);
            return mod;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exc) {
            throw new IOException(exc);
        }
    }

    private static synchronized boolean createStorageVolume(File pToCreate, long pLength) throws IOException {
        FileOutputStream outStream = null;
        try {
            File parent;
            if (pToCreate.exists()) {
                if (!pToCreate.delete()) {
                    LOGGER.debug("Removal of old storage " + pToCreate.toString() + " unsucessful.");
                    boolean bl = false;
                    return bl;
                }
                LOGGER.debug("Removal of old storage " + pToCreate.toString() + " sucessful.");
            }
            if (!(parent = pToCreate.getCanonicalFile().getParentFile()).exists() && !parent.mkdirs()) {
                throw new FileNotFoundException("Unable to create directory: " + parent.getAbsolutePath());
            }
            pToCreate.createNewFile();
            outStream = new FileOutputStream(pToCreate);
            FileChannel fcout = outStream.getChannel();
            fcout.position(pLength);
            outStream.write(26);
            fcout.force(true);
            LOGGER.debug("Creation of storage " + pToCreate.toString() + " sucessful.");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Exception creating storage volume " + pToCreate.getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Exception closing storage volume: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static boolean recursiveDelete(File pFile) {
        if (pFile.isDirectory()) {
            for (File child : pFile.listFiles()) {
                if (RandomAccessStorageModule.recursiveDelete(child)) continue;
                return false;
            }
        }
        return pFile.delete();
    }
}

