/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.util;

import java.nio.ByteBuffer;

public class Debug {
    private static final int BYTES_PER_LINE = 4;

    private Debug() {
    }

    public static void printByteBuffer(ByteBuffer buffer) {
        System.out.println(Debug.byteBufferToString(buffer));
    }

    public static String byteBufferToString(ByteBuffer buffer) {
        if (buffer == null) {
            return "null";
        }
        int numberOfBytes = buffer.limit();
        StringBuilder sb = new StringBuilder();
        buffer.position(0);
        for (int i = 1; i <= numberOfBytes; ++i) {
            sb.append("0x");
            int value = 0xFF & buffer.get();
            if (value < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(value));
            if (i % 4 == 0) {
                sb.append("\n");
                continue;
            }
            sb.append("   ");
        }
        return sb.toString();
    }
}

