/*
 * Decompiled with CFR 0.152.
 */
package org.jscsi.target.util;

import java.nio.ByteBuffer;

public final class ReadWrite {
    private ReadWrite() {
    }

    public static final int readOneByteInt(ByteBuffer buffer, int start) {
        byte b = buffer.get(start);
        return b & 0xFF;
    }

    public static final int readOneByteInt(byte[] array, int start) {
        return array[start] & 0xFF;
    }

    public static final int readTwoByteInt(ByteBuffer buffer, int start) {
        byte b1 = buffer.get(start);
        byte b2 = buffer.get(start + 1);
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    public static final int readTwoByteInt(byte[] array, int start) {
        return (array[start] & 0xFF) << 8 | array[start + 1] & 0xFF;
    }

    public static final int readThreeByteInt(ByteBuffer buffer, int start) {
        byte b1 = buffer.get(start);
        byte b2 = buffer.get(start + 1);
        byte b3 = buffer.get(start + 2);
        return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    public static final int readThreeByteInt(byte[] array, int start) {
        return (array[start] & 0xFF) << 16 | (array[start + 1] & 0xFF) << 8 | array[start + 2] & 0xFF;
    }

    public static final int readFourByteInt(ByteBuffer buffer, int start) {
        byte b1 = buffer.get(start);
        byte b2 = buffer.get(start + 1);
        byte b3 = buffer.get(start + 2);
        byte b4 = buffer.get(start + 3);
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static final int readFourByteInt(byte[] array, int start) {
        return (array[start] & 0xFF) << 24 | (array[start + 1] & 0xFF) << 16 | (array[start + 2] & 0xFF) << 8 | array[start + 3] & 0xFF;
    }

    public static ByteBuffer[] stringToTextDataSegments(String string, int bufferSize) {
        int numberOfParts = string.length() / bufferSize + 1;
        ByteBuffer[] segments = new ByteBuffer[numberOfParts];
        int bytesRemaining = string.length();
        for (int i = 0; i < numberOfParts; ++i) {
            segments[i] = bytesRemaining > bufferSize ? ReadWrite.stringToByteBuffer(string.substring(i * bufferSize, (i + 1) * bufferSize)) : ReadWrite.stringToByteBuffer(string.substring(i * bufferSize));
        }
        return segments;
    }

    private static ByteBuffer stringToByteBuffer(String string) {
        ByteBuffer buffer = ByteBuffer.allocate(string.length());
        for (int i = 0; i < string.length(); ++i) {
            buffer.put((byte)string.charAt(i));
        }
        buffer.clear();
        return buffer;
    }

    public static final void appendTextDataSegmentToStringBuffer(ByteBuffer byteBuffer, StringBuilder stringBuilder) {
        String s = new String(byteBuffer.array());
        stringBuilder.append(s);
    }

    public static final void writeInt(int value, ByteBuffer buffer, int start) {
        buffer.position(start);
        buffer.put((byte)(value >>> 24));
        buffer.put((byte)(value >>> 16));
        buffer.put((byte)(value >>> 8));
        buffer.put((byte)value);
    }

    public static String byteBufferToString(ByteBuffer buffer) {
        buffer.rewind();
        return new String(buffer.array());
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(value >> 8 * (bytes.length - 1 - i));
        }
        return bytes;
    }

    public static void writeLong(ByteBuffer buffer, long value, int index) {
        byte[] bytes = ReadWrite.longToBytes(value);
        buffer.position(index);
        for (int i = 0; i < bytes.length; ++i) {
            buffer.put(bytes[i]);
        }
    }

    public static void writeTwoByteInt(ByteBuffer buffer, int value, int index) {
        buffer.position(index);
        buffer.put((byte)(value >> 8));
        buffer.put((byte)value);
    }

    public static void writeThreeByteInt(ByteBuffer buffer, int value, int index) {
        buffer.position(index);
        buffer.put((byte)(value >> 16));
        buffer.put((byte)(value >> 8));
        buffer.put((byte)value);
    }

    public static long readUnsignedInt(ByteBuffer buffer, int start) {
        return (long)ReadWrite.readFourByteInt(buffer, start) & 0xFFFFFFFFL;
    }
}

