/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.CleanerStatDefinition;
import com.sleepycat.je.cleaner.FileProcessor;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonRunner;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.FloatStat;
import com.sleepycat.je.utilint.FormatUtil;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
implements DaemonRunner,
EnvConfigObserver {
    static final String CLEAN_IN = "CleanIN:";
    static final String CLEAN_LN = "CleanLN:";
    static final String CLEAN_MIGRATE_LN = "CleanMigrateLN:";
    static final String CLEAN_PENDING_LN = "CleanPendingLN:";
    static final CacheMode UPDATE_GENERATION = CacheMode.UNCHANGED;
    static final boolean DO_CRITICAL_EVICTION = true;
    static final int BACKLOG_ALERT_COUNT = 5;
    static final int BACKLOG_ALERT_FLOOR = 5;
    private static final String DELETED_SUBDIR = "deleted";
    private final LinkedList<Integer> backlogAlertList = new LinkedList();
    StatGroup stats;
    LongStat nCleanerRuns;
    LongStat nCleanerDeletions;
    LongStat nINsObsolete;
    LongStat nINsCleaned;
    LongStat nINsDead;
    LongStat nINsMigrated;
    LongStat nBINDeltasObsolete;
    LongStat nBINDeltasCleaned;
    LongStat nBINDeltasDead;
    LongStat nBINDeltasMigrated;
    LongStat nLNsObsolete;
    LongStat nLNsCleaned;
    LongStat nLNsDead;
    LongStat nLNsLocked;
    LongStat nLNsMigrated;
    LongStat nLNsMarked;
    LongStat nLNQueueHits;
    LongStat nPendingLNsProcessed;
    LongStat nMarkedLNsProcessed;
    LongStat nToBeCleanedLNsProcessed;
    LongStat nClusterLNsProcessed;
    LongStat nPendingLNsLocked;
    LongStat nEntriesRead;
    LongStat nDiskReads;
    LongStat nRepeatIteratorReads;
    LongStat totalLogSize;
    FloatStat lnSizeCorrectionFactor;
    IntStat lastKnownUtilization;
    long lockTimeout;
    int readBufferSize;
    int lookAheadCacheSize;
    long nDeadlockRetries;
    boolean expunge;
    boolean useDeletedDir;
    int maxBatchFiles;
    long cleanerBytesInterval;
    boolean trackDetail;
    boolean fetchObsoleteSize;
    int dbCacheClearCount;
    private final boolean rmwFixEnabled;
    int minUtilization;
    int minFileUtilization;
    int minAge;
    private final String name;
    private final EnvironmentImpl env;
    private final UtilizationProfile profile;
    private final UtilizationTracker tracker;
    private final UtilizationCalculator calculator;
    private final FileSelector fileSelector;
    private FileProcessor[] threads;
    private final List<Long> protectedFileRanges;
    private final Logger logger;
    final AtomicLong totalRuns;
    TestHook fileChosenHook;
    private final AtomicBoolean processPendingReentrancyGuard = new AtomicBoolean(false);

    public Cleaner(EnvironmentImpl env, String name) throws DatabaseException {
        this.env = env;
        this.name = name;
        this.stats = new StatGroup("Cleaning", "Frequency and extent of log file cleaning activity.");
        this.nCleanerRuns = new LongStat(this.stats, CleanerStatDefinition.CLEANER_RUNS);
        this.nCleanerDeletions = new LongStat(this.stats, CleanerStatDefinition.CLEANER_DELETIONS);
        this.nINsObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_OBSOLETE);
        this.nINsCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_CLEANED);
        this.nINsDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_DEAD);
        this.nINsMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_INS_MIGRATED);
        this.nBINDeltasObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_OBSOLETE);
        this.nBINDeltasCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_CLEANED);
        this.nBINDeltasDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_DEAD);
        this.nBINDeltasMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_BIN_DELTAS_MIGRATED);
        this.nLNsObsolete = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_OBSOLETE);
        this.nLNsCleaned = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_CLEANED);
        this.nLNsDead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_DEAD);
        this.nLNsLocked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_LOCKED);
        this.nLNsMigrated = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_MIGRATED);
        this.nLNsMarked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNS_MARKED);
        this.nLNQueueHits = new LongStat(this.stats, CleanerStatDefinition.CLEANER_LNQUEUE_HITS);
        this.nPendingLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_PENDING_LNS_PROCESSED);
        this.nMarkedLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_MARKED_LNS_PROCESSED);
        this.nToBeCleanedLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_TO_BE_CLEANED_LNS_PROCESSED);
        this.nClusterLNsProcessed = new LongStat(this.stats, CleanerStatDefinition.CLEANER_CLUSTER_LNS_PROCESSED);
        this.nPendingLNsLocked = new LongStat(this.stats, CleanerStatDefinition.CLEANER_PENDING_LNS_LOCKED);
        this.nEntriesRead = new LongStat(this.stats, CleanerStatDefinition.CLEANER_ENTRIES_READ);
        this.nDiskReads = new LongStat(this.stats, CleanerStatDefinition.CLEANER_DISK_READS);
        this.nRepeatIteratorReads = new LongStat(this.stats, CleanerStatDefinition.CLEANER_REPEAT_ITERATOR_READS);
        this.totalLogSize = new LongStat(this.stats, CleanerStatDefinition.CLEANER_TOTAL_LOG_SIZE);
        this.lastKnownUtilization = new IntStat(this.stats, CleanerStatDefinition.CLEANER_LAST_KNOWN_UTILIZATION);
        this.tracker = new UtilizationTracker(env, this);
        this.profile = new UtilizationProfile(env, this.tracker);
        this.calculator = new UtilizationCalculator(env, this);
        this.fileSelector = new FileSelector();
        this.threads = new FileProcessor[0];
        this.protectedFileRanges = new LinkedList<Long>();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.totalRuns = new AtomicLong(0L);
        this.trackDetail = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_TRACK_DETAIL);
        this.rmwFixEnabled = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_RMW_FIX);
        this.envConfigUpdate(env.getConfigManager(), null);
        env.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager cm, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.lockTimeout = cm.getDuration(EnvironmentParams.CLEANER_LOCK_TIMEOUT);
        this.readBufferSize = cm.getInt(EnvironmentParams.CLEANER_READ_SIZE);
        if (this.readBufferSize <= 0) {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        this.lookAheadCacheSize = cm.getInt(EnvironmentParams.CLEANER_LOOK_AHEAD_CACHE_SIZE);
        this.nDeadlockRetries = cm.getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
        this.expunge = cm.getBoolean(EnvironmentParams.CLEANER_REMOVE);
        this.useDeletedDir = cm.getBoolean(EnvironmentParams.CLEANER_USE_DELETED_DIR);
        this.maxBatchFiles = cm.getInt(EnvironmentParams.CLEANER_MAX_BATCH_FILES);
        this.dbCacheClearCount = cm.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        int nThreads = cm.getInt(EnvironmentParams.CLEANER_THREADS);
        assert (nThreads > 0);
        if (nThreads != this.threads.length) {
            int i;
            for (int i2 = nThreads; i2 < this.threads.length; ++i2) {
                if (this.threads[i2] == null) continue;
                this.threads[i2].shutdown();
                this.threads[i2] = null;
            }
            FileProcessor[] newThreads = new FileProcessor[nThreads];
            for (i = 0; i < nThreads && i < this.threads.length; ++i) {
                newThreads[i] = this.threads[i];
            }
            this.threads = newThreads;
            for (i = 0; i < nThreads; ++i) {
                if (this.threads[i] != null) continue;
                this.threads[i] = new FileProcessor(this.name + '-' + (i + 1), this.env, this, this.profile, this.calculator, this.fileSelector);
            }
        }
        this.cleanerBytesInterval = cm.getLong(EnvironmentParams.CLEANER_BYTES_INTERVAL);
        if (this.cleanerBytesInterval == 0L) {
            this.cleanerBytesInterval = cm.getLong(EnvironmentParams.LOG_FILE_MAX) / 4L;
        }
        this.fetchObsoleteSize = cm.getBoolean(EnvironmentParams.CLEANER_FETCH_OBSOLETE_SIZE);
        this.minAge = cm.getInt(EnvironmentParams.CLEANER_MIN_AGE);
        this.minUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_UTILIZATION);
        this.minFileUtilization = cm.getInt(EnvironmentParams.CLEANER_MIN_FILE_UTILIZATION);
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.tracker;
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.profile;
    }

    public UtilizationCalculator getUtilizationCalculator() {
        return this.calculator;
    }

    public FileSelector getFileSelector() {
        return this.fileSelector;
    }

    public boolean getFetchObsoleteSize(DatabaseImpl db) {
        return this.fetchObsoleteSize && !db.isLNImmediatelyObsolete();
    }

    public boolean isRMWFixEnabled() {
        return this.rmwFixEnabled;
    }

    public void setFileChosenHook(TestHook hook) {
        this.fileChosenHook = hook;
    }

    @Override
    public void runOrPause(boolean run) {
        if (!this.env.isNoLocking()) {
            for (FileProcessor processor : this.threads) {
                if (processor == null) continue;
                processor.runOrPause(run);
            }
        }
    }

    public void wakeup() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.wakeup();
        }
    }

    @Override
    public void requestShutdown() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            thread.requestShutdown();
        }
    }

    @Override
    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i] == null) continue;
            this.threads[i].shutdown();
            this.threads[i].clearEnv();
            this.threads[i] = null;
        }
    }

    @Override
    public int getNWakeupRequests() {
        int count = 0;
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            count += thread.getNWakeupRequests();
        }
        return count;
    }

    private boolean areThreadsRunning() {
        for (FileProcessor thread : this.threads) {
            if (thread == null) continue;
            return thread.isRunning();
        }
        return false;
    }

    public int doClean(boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        FileProcessor processor = new FileProcessor("", this.env, this, this.profile, this.calculator, this.fileSelector);
        return processor.doClean(false, cleanMultipleFiles, forceCleaning);
    }

    public StatGroup loadStats(StatsConfig config) {
        if (!config.getFast()) {
            this.totalLogSize.set(this.profile.getTotalLogSize());
        }
        this.lastKnownUtilization.set(this.calculator.getLastKnownUtilization());
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        copyStats.addAll(this.fileSelector.loadStats());
        return copyStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void deleteSafeToDeleteFiles() throws DatabaseException {
        FileManager fileManager;
        Object fileNum;
        this.env.checkIfInvalid();
        if (this.env.mayNotWrite()) {
            return;
        }
        NavigableSet<Long> safeToDeleteFiles = this.fileSelector.copySafeToDeleteFiles();
        if (safeToDeleteFiles == null) {
            return;
        }
        NavigableSet<Long> unprotectedFiles = this.env.getUnprotectedFileSet(safeToDeleteFiles);
        if (unprotectedFiles == null) {
            return;
        }
        if (unprotectedFiles.isEmpty()) {
            this.traceAndLogProtectedFiles("they are protected by replication", safeToDeleteFiles);
            return;
        }
        Long[] unprotectedFilesArray = unprotectedFiles.toArray(new Long[0]);
        for (int i = unprotectedFilesArray.length - 1; i >= 0; --i) {
            fileNum = unprotectedFilesArray[i];
            VLSN lastVlsn = this.fileSelector.getLastVLSN((Long)fileNum);
            if (lastVlsn == null || lastVlsn.isNull()) continue;
            this.env.vlsnHeadTruncate(lastVlsn, (Long)fileNum);
            break;
        }
        if (!(fileManager = this.env.getFileManager()).lockEnvironment(false, true)) {
            this.traceAndLogProtectedFiles("of read-only processes", safeToDeleteFiles);
            return;
        }
        try {
            fileNum = this.protectedFileRanges;
            synchronized (fileNum) {
                if (!this.protectedFileRanges.isEmpty()) {
                    Long minRangeStart = Collections.min(this.protectedFileRanges);
                    if (minRangeStart <= (Long)unprotectedFiles.first()) {
                        return;
                    }
                    unprotectedFiles = unprotectedFiles.headSet(minRangeStart, false);
                }
                Iterator<Long> iter = unprotectedFiles.iterator();
                while (iter.hasNext()) {
                    boolean deleted;
                    Long fileNum2 = iter.next();
                    String expungeLabel = this.expunge ? "delete" : "rename";
                    String expungedLabel = expungeLabel + "d";
                    try {
                        if (this.expunge) {
                            deleted = fileManager.deleteFile(fileNum2);
                        } else {
                            File newFile = fileManager.renameFile(fileNum2, ".del", this.useDeletedDir ? DELETED_SUBDIR : null);
                            if (newFile != null) {
                                newFile.setLastModified(System.currentTimeMillis());
                            }
                            deleted = newFile != null;
                        }
                    }
                    catch (IOException e) {
                        throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_WRITE, "Unable to " + expungeLabel + " " + fileNum2, e);
                    }
                    if (deleted) {
                        LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, "Cleaner deleted file 0x" + Long.toHexString(fileNum2));
                        continue;
                    }
                    if (!fileManager.isFileValid(fileNum2)) {
                        LoggerUtils.traceAndLog(this.logger, this.env, Level.SEVERE, "Cleaner deleteSafeToDeleteFiles Log file 0x" + Long.toHexString(fileNum2) + " was previously " + expungedLabel + ".  State: " + this.fileSelector);
                        continue;
                    }
                    iter.remove();
                    LoggerUtils.traceAndLog(this.logger, this.env, Level.WARNING, "Cleaner deleteSafeToDeleteFiles Log file 0x" + Long.toHexString(fileNum2) + " could not be " + expungedLabel + ". This operation will be " + "retried at the next checkpoint. State: " + this.fileSelector);
                }
            }
        }
        finally {
            fileManager.releaseExclusiveLock();
        }
        this.profile.removePerDbMetadata(unprotectedFiles, this.fileSelector.getCleanedDatabases(unprotectedFiles));
        for (Long fileNum3 : unprotectedFiles) {
            try {
                this.profile.removePerFileMetadata(fileNum3);
            }
            finally {
                this.fileSelector.removeDeletedFile(fileNum3, this.env.getMemoryBudget());
            }
            this.nCleanerDeletions.increment();
        }
        if (safeToDeleteFiles.size() <= unprotectedFiles.size()) return;
        ArrayList<Long> filesNotDeleted = new ArrayList<Long>(safeToDeleteFiles.size() - unprotectedFiles.size());
        Iterator<Long> i$ = safeToDeleteFiles.iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.traceAndLogProtectedFiles("they are protected by DbBackup or replication", new TreeSet<Long>(filesNotDeleted));
                return;
            }
            Long file = i$.next();
            if (unprotectedFiles.contains(file)) continue;
            filesNotDeleted.add(file);
        }
    }

    private void traceAndLogProtectedFiles(String reason, SortedSet<Long> filesNotDeleted) {
        LoggerUtils.traceAndLog(this.logger, this.env, Level.INFO, "Cleaner has " + filesNotDeleted.size() + " files not deleted because " + reason + ". Files:" + FormatUtil.asString(filesNotDeleted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProtectedFileRange(long firstProtectedFile) {
        List<Long> list = this.protectedFileRanges;
        synchronized (list) {
            this.protectedFileRanges.add(firstProtectedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProtectedFileRange(long firstProtectedFile) {
        List<Long> list = this.protectedFileRanges;
        synchronized (list) {
            if (!this.protectedFileRanges.remove(firstProtectedFile)) {
                throw EnvironmentFailureException.unexpectedState("File range starting with 0x" + Long.toHexString(firstProtectedFile) + " is not currently protected");
            }
        }
    }

    public FileSelector.CheckpointStartCleanerState getFilesAtCheckpointStart() throws DatabaseException {
        this.processPending();
        return this.fileSelector.getFilesAtCheckpointStart();
    }

    public void updateFilesAtCheckpointEnd(FileSelector.CheckpointStartCleanerState info) throws DatabaseException {
        this.fileSelector.updateFilesAtCheckpointEnd(info);
        this.deleteSafeToDeleteFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkBacklogGrowth() {
        float newAvg;
        float oldAvg;
        boolean averagesAreValid;
        int oldBacklog;
        int newBacklog = this.fileSelector.getBacklog();
        LinkedList<Integer> linkedList = this.backlogAlertList;
        synchronized (linkedList) {
            oldBacklog = this.backlogAlertList.size() > 0 ? this.backlogAlertList.peekLast() : 0;
            averagesAreValid = this.backlogAlertList.size() >= 5;
            oldAvg = Cleaner.getAverage(this.backlogAlertList);
            this.backlogAlertList.addLast(newBacklog);
            while (this.backlogAlertList.size() > 5) {
                this.backlogAlertList.removeFirst();
            }
            newAvg = Cleaner.getAverage(this.backlogAlertList);
        }
        if (newBacklog < 5) {
            return;
        }
        if (newBacklog <= oldBacklog) {
            return;
        }
        if (!averagesAreValid || newAvg <= oldAvg) {
            return;
        }
        String msg = String.format("Average cleaner backlog has grown from %.1f to %.1f. If the cleaner continues to be unable to make progress, the JE cache size and/or number of cleaner threads are probably too small. If this is not corrected, eventually all available disk space will be used.", Float.valueOf(oldAvg), Float.valueOf(newAvg));
        LoggerUtils.logMsg(this.logger, this.env, Level.SEVERE, msg);
    }

    private static float getAverage(Collection<Integer> integers) {
        float total = 0.0f;
        for (int i : integers) {
            total += (float)i;
        }
        return total / (float)integers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPending() throws DatabaseException {
        if (!this.processPendingReentrancyGuard.compareAndSet(false, true)) {
            return;
        }
        try {
            DatabaseId[] pendingDBs;
            DbTree dbMapTree = this.env.getDbTree();
            Map<Long, LNInfo> pendingLNs = this.fileSelector.getPendingLNs();
            if (pendingLNs != null) {
                TreeLocation location = new TreeLocation();
                for (Map.Entry<Long, LNInfo> entry : pendingLNs.entrySet()) {
                    long logrecLsn = entry.getKey();
                    LNInfo info = entry.getValue();
                    DatabaseId dbId = info.getDbId();
                    DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                    try {
                        byte[] key = info.getKey();
                        LN ln = info.getLN();
                        this.env.daemonEviction(true);
                        this.processPendingLN(logrecLsn, ln, db, key, location);
                    }
                    finally {
                        dbMapTree.releaseDb(db);
                    }
                    this.env.sleepAfterBackgroundIO();
                }
            }
            if ((pendingDBs = this.fileSelector.getPendingDBs()) != null) {
                for (DatabaseId dbId : pendingDBs) {
                    DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                    try {
                        if (db != null && !db.isDeleteFinished()) continue;
                        this.fileSelector.removePendingDB(dbId);
                    }
                    finally {
                        dbMapTree.releaseDb(db);
                    }
                }
            }
        }
        finally {
            this.processPendingReentrancyGuard.set(false);
        }
    }

    private void processPendingLN(long logrecLsn, LN lnFromLog, DatabaseImpl db, byte[] keyFromLog, TreeLocation location) throws DatabaseException {
        boolean parentFound = false;
        boolean processedHere = true;
        boolean lockDenied = false;
        boolean obsolete = false;
        boolean completed = false;
        Locker locker = null;
        IN bin = null;
        try {
            this.nPendingLNsProcessed.increment();
            if (db == null || db.isDeleted()) {
                this.addPendingDB(db);
                this.nLNsDead.increment();
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            assert (tree != null);
            locker = BasicLocker.createBasicLocker(this.env, false);
            locker.setPreemptable(false);
            LockResult lockRet = locker.nonBlockingLock(logrecLsn, LockType.READ, false, db);
            if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                this.nPendingLNsLocked.increment();
                lockDenied = true;
                completed = true;
                return;
            }
            parentFound = tree.getParentBINForChildLN(location, keyFromLog, false, false, UPDATE_GENERATION);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                this.nLNsDead.increment();
                obsolete = true;
                completed = true;
                return;
            }
            processedHere = false;
            this.migratePendingLN(db, logrecLsn, bin.getLsn(index), (BIN)bin, index);
            completed = true;
        }
        catch (DatabaseException DBE) {
            DBE.printStackTrace();
            LoggerUtils.traceAndLogException(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
            throw DBE;
        }
        finally {
            if (bin != null) {
                bin.releaseLatch();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            if (processedHere) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(logrecLsn);
                }
                this.logFine(CLEAN_PENDING_LN, lnFromLog, -1L, completed, obsolete, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migratePendingLN(DatabaseImpl db, long logrecLsn, long treeLsn, BIN bin, int index) throws DatabaseException {
        LN ln;
        boolean completed;
        boolean migrated;
        boolean obsolete;
        block34: {
            Locker locker;
            boolean clearTarget;
            boolean lockDenied;
            block32: {
                block33: {
                    block28: {
                        block31: {
                            block29: {
                                block30: {
                                    block26: {
                                        block27: {
                                            block24: {
                                                block25: {
                                                    obsolete = false;
                                                    migrated = false;
                                                    lockDenied = false;
                                                    completed = false;
                                                    clearTarget = false;
                                                    locker = null;
                                                    ln = null;
                                                    try {
                                                        if (treeLsn != -1L) break block24;
                                                        completed = true;
                                                        if (completed && !lockDenied) {
                                                            this.fileSelector.removePendingLN(logrecLsn);
                                                        }
                                                        if (clearTarget) {
                                                            bin.evictLN(index);
                                                        }
                                                        if (locker == null) break block25;
                                                    }
                                                    catch (Throwable throwable) {
                                                        if (completed && !lockDenied) {
                                                            this.fileSelector.removePendingLN(logrecLsn);
                                                        }
                                                        if (clearTarget) {
                                                            bin.evictLN(index);
                                                        }
                                                        if (locker != null) {
                                                            locker.operationEnd();
                                                        }
                                                        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                                        throw throwable;
                                                    }
                                                    locker.operationEnd();
                                                }
                                                this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                                return;
                                            }
                                            if (!bin.isEntryKnownDeleted(index)) break block26;
                                            this.nLNsDead.increment();
                                            obsolete = true;
                                            completed = true;
                                            if (completed && !lockDenied) {
                                                this.fileSelector.removePendingLN(logrecLsn);
                                            }
                                            if (clearTarget) {
                                                bin.evictLN(index);
                                            }
                                            if (locker == null) break block27;
                                            locker.operationEnd();
                                        }
                                        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                        return;
                                    }
                                    if (logrecLsn == treeLsn) break block28;
                                    locker = BasicLocker.createBasicLocker(this.env, false);
                                    locker.setPreemptable(false);
                                    LockResult lockRet = locker.nonBlockingLock(treeLsn, LockType.READ, false, db);
                                    if (lockRet.getLockGrant() != LockGrantType.DENIED) break block29;
                                    this.nLNsLocked.increment();
                                    lockDenied = true;
                                    completed = true;
                                    if (completed && !lockDenied) {
                                        this.fileSelector.removePendingLN(logrecLsn);
                                    }
                                    if (clearTarget) {
                                        bin.evictLN(index);
                                    }
                                    if (locker == null) break block30;
                                    locker.operationEnd();
                                }
                                this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                                return;
                            }
                            this.nLNsDead.increment();
                            obsolete = true;
                            completed = true;
                            if (completed && !lockDenied) {
                                this.fileSelector.removePendingLN(logrecLsn);
                            }
                            if (clearTarget) {
                                bin.evictLN(index);
                            }
                            if (locker == null) break block31;
                            locker.operationEnd();
                        }
                        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                        return;
                    }
                    if (bin.isEmbeddedLN(index)) {
                        throw EnvironmentFailureException.unexpectedState(this.env, "LN is embedded although its associated logrec (at " + treeLsn + " does not have the embedded flag on");
                    }
                    ln = (LN)bin.getTarget(index);
                    if (ln == null) {
                        ln = bin.fetchLN(index, CacheMode.EVICT_LN);
                        boolean bl = clearTarget = !db.getId().equals(DbTree.ID_DB_ID);
                    }
                    if (ln != null && !ln.isDeleted()) break block32;
                    bin.setKnownDeletedAndEvictLN(index);
                    this.nLNsDead.increment();
                    obsolete = true;
                    completed = true;
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(logrecLsn);
                    }
                    if (clearTarget) {
                        bin.evictLN(index);
                    }
                    if (locker == null) break block33;
                    locker.operationEnd();
                }
                this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
                return;
            }
            LogItem logItem = ln.log(this.env, db, null, null, false, bin.getKey(index), false, treeLsn, bin.getLastLoggedSize(index), false, true, Cleaner.getMigrationRepContext(ln));
            bin.updateEntry(index, logItem.lsn, ln.getVLSNSequence(), logItem.size);
            this.nLNsMigrated.increment();
            CursorImpl.lockAfterLsnChange(db, treeLsn, logItem.lsn, locker);
            migrated = true;
            completed = true;
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(logrecLsn);
            }
            if (clearTarget) {
                bin.evictLN(index);
            }
            if (locker == null) break block34;
            locker.operationEnd();
        }
        this.logFine(CLEAN_PENDING_LN, ln, treeLsn, completed, obsolete, migrated);
    }

    static ReplicationContext getMigrationRepContext(LN ln) {
        long vlsnSeq = ln.getVLSNSequence();
        if (vlsnSeq <= 0L) {
            return ReplicationContext.NO_REPLICATE;
        }
        return new ReplicationContext(new VLSN(vlsnSeq), false);
    }

    void addPendingDB(DatabaseImpl db) {
        DatabaseId id;
        if (db != null && db.isDeleted() && !db.isDeleteFinished() && this.fileSelector.addPendingDB(id = db.getId())) {
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, "CleanAddPendingDB " + id);
        }
    }

    void logFine(String action, Node node, long logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(action);
            if (node instanceof IN) {
                sb.append(" node=");
                sb.append(((IN)node).getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, sb.toString());
        }
    }

    public void close() {
        this.profile.close();
        this.tracker.close();
        this.fileSelector.close(this.env.getMemoryBudget());
    }
}

