/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter.impl;

import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class ArbiterVLSNTracker {
    private final int VERSION = 1;
    private RandomAccessFile raf;
    private final File dataFile;
    private VLSN currentVLSN = VLSN.NULL_VLSN;
    private final int VERSION_OFFSET = 0;
    private final int NODEID_OFFSET = 32;
    private final int DATA_OFFSET = 64;
    private int nodeId = -1;

    ArbiterVLSNTracker(File file) {
        this.dataFile = file;
        boolean fileExists = this.dataFile.exists();
        try {
            this.raf = new RandomAccessFile(this.dataFile, "rwd");
            if (fileExists) {
                if (this.readVersion() != 1) {
                    throw new RuntimeException("Arbiter data file does not have a supported version field " + this.dataFile.getAbsolutePath());
                }
                this.nodeId = this.readNodeId();
                if (this.raf.length() > 64L) {
                    this.raf.seek(64L);
                    this.currentVLSN = new VLSN(this.raf.readLong());
                }
            } else {
                this.writeVersion(1);
                this.writeNodeIdInternal(this.nodeId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to open the Arbiter data file " + this.dataFile.getAbsolutePath() + " exception " + e.getMessage());
        }
    }

    public synchronized void writeNodeId(int id) {
        if (this.nodeId == id) {
            return;
        }
        this.writeNodeIdInternal(id);
    }

    public synchronized int getCachedNodeId() {
        return this.nodeId;
    }

    private void writeNodeIdInternal(int id) {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to write the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        try {
            this.raf.seek(32L);
            this.raf.writeInt(id);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    private int readNodeId() {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to read the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        try {
            this.raf.seek(32L);
            return this.raf.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    public synchronized void writeVersion(int id) {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to write the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        if (this.nodeId == id) {
            return;
        }
        try {
            this.raf.seek(0L);
            this.raf.writeInt(id);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    private int readVersion() {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to read the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        try {
            this.raf.seek(0L);
            return this.raf.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    public synchronized void write(VLSN value) {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to write the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        if (value.compareTo(this.currentVLSN) > 0) {
            this.currentVLSN = new VLSN(value.getSequence());
            try {
                this.raf.seek(64L);
                this.raf.writeLong(this.currentVLSN.getSequence());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.raf = null;
            }
        }
    }

    public VLSN get() {
        return this.currentVLSN;
    }
}

