/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.ArbiterFeederStatDefinition;
import com.sleepycat.je.rep.stream.FeederSource;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ArbiterFeederSource
implements FeederSource {
    private static final long OFFER_WAIT = 1000000000L;
    private static final long MESSAGE_OUTPUT_INTERVAL = 1000L;
    private final BlockingQueue<LogItem> queue;
    private final EnvironmentImpl envImpl;
    private final StatGroup stats;
    private final LongStat nQueueFull;
    private final Logger logger;

    public ArbiterFeederSource(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, NameIdPair nameIdPair) throws DatabaseException {
        int queueSize = envImpl.getConfigManager().getInt(RepParams.ARBITER_OUTPUT_QUEUE_SIZE);
        this.queue = new ArrayBlockingQueue<LogItem>(queueSize);
        this.envImpl = envImpl;
        this.stats = new StatGroup("ArbiterFeeder", "ArbiterFeeder statistics");
        this.nQueueFull = new LongStat(this.stats, ArbiterFeederStatDefinition.QUEUE_FULL);
        this.logger = envImpl.getLogger();
    }

    public void addCommit(LogItem commitItem) {
        try {
            if (!this.queue.offer(commitItem, 1000000000L, TimeUnit.NANOSECONDS)) {
                this.nQueueFull.increment();
                if ((this.nQueueFull.get() - 1L) % 1000L == 0L) {
                    LoggerUtils.severe(this.logger, this.envImpl, "Arbiter Feeder Source queue full. The configuration parameter je.rep.arbiterOutputQueueSize should be increased. The number of failed  insertions is: " + this.nQueueFull.get());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void init(VLSN startVLSN) throws DatabaseException, IOException {
        this.queue.clear();
    }

    @Override
    public OutputWireRecord getWireRecord(VLSN vlsn, int waitTime) throws DatabaseException, InterruptedException, IOException {
        LogItem commitItem = this.queue.poll(waitTime, TimeUnit.MILLISECONDS);
        if (commitItem != null) {
            return new OutputWireRecord(this.envImpl, commitItem);
        }
        return null;
    }

    public StatGroup loadStats(StatsConfig config) throws DatabaseException {
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        return copyStats;
    }

    @Override
    public String dumpState() {
        return null;
    }
}

