/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.rocksdb;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.rocksdb.RocksDBKVStore;
import org.jsimpledb.kv.rocksdb.SnapshotRocksDBKVStore;
import org.jsimpledb.kv.util.ForwardingKVStore;
import org.jsimpledb.util.ByteUtil;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBAtomicKVStore
extends ForwardingKVStore
implements AtomicKVStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicBoolean shutdownHookRegistered = new AtomicBoolean();
    private Options options;
    private File directory;
    private RocksDBKVStore kv;
    private RocksDB db;

    public RocksDBAtomicKVStore() {
        this.setOptions(new Options().setCreateIfMissing(true));
    }

    public synchronized File getDirectory() {
        return this.directory;
    }

    public synchronized void setDirectory(File directory) {
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.directory = directory;
    }

    public synchronized RocksDB getDB() {
        Preconditions.checkState((this.db != null ? 1 : 0) != 0, (Object)"not started");
        return this.db;
    }

    public synchronized Options getOptions() {
        return this.options;
    }

    public synchronized void setOptions(Options options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"null options");
        Preconditions.checkState((this.db == null ? 1 : 0) != 0, (Object)"already started");
        this.options = options;
        this.options.setMergeOperatorName("uint64add");
        this.setLogger(this.options);
    }

    private void setLogger(Options options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0);
        options.setLogger(new org.rocksdb.Logger(options){

            protected void log(InfoLogLevel level, String message) {
                switch (level) {
                    case DEBUG_LEVEL: {
                        RocksDBAtomicKVStore.this.log.trace("[RocksDB] " + message);
                        break;
                    }
                    case INFO_LEVEL: {
                        RocksDBAtomicKVStore.this.log.info("[RocksDB] " + message);
                        break;
                    }
                    case WARN_LEVEL: {
                        RocksDBAtomicKVStore.this.log.warn("[RocksDB] " + message);
                        break;
                    }
                    default: {
                        RocksDBAtomicKVStore.this.log.error("[RocksDB] " + message);
                    }
                }
            }
        });
    }

    @PostConstruct
    public synchronized void start() {
        if (this.db != null) {
            return;
        }
        this.log.info("starting " + (Object)((Object)this));
        Preconditions.checkState((this.directory != null ? 1 : 0) != 0, (Object)"no directory configured");
        if (!this.directory.exists()) {
            if (!this.options.createIfMissing()) {
                throw new RuntimeException("directory `" + this.directory + "' does not exist");
            }
            if (!this.directory.mkdirs()) {
                throw new RuntimeException("failed to create directory `" + this.directory + "'");
            }
        }
        if (!this.directory.isDirectory()) {
            throw new RuntimeException("file `" + this.directory + "' is not a directory");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("opening " + (Object)((Object)this) + " RocksDB database");
        }
        try {
            this.db = RocksDB.open((Options)this.options, (String)this.directory.toString());
        }
        catch (RocksDBException e) {
            throw new RuntimeException("RocksDB database startup failed", e);
        }
        this.kv = new RocksDBKVStore(this.db);
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    RocksDBAtomicKVStore.this.stop();
                }
            });
        }
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.db == null) {
            return;
        }
        this.log.info("stopping " + (Object)((Object)this));
        this.kv.close();
        this.kv = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.info("closing " + (Object)((Object)this) + " RocksDB database");
            }
            this.db.close();
        }
        catch (Throwable e) {
            this.log.error("caught exception closing database during shutdown (ignoring)", e);
        }
        this.db = null;
    }

    protected synchronized RocksDBKVStore delegate() {
        Preconditions.checkState((this.db != null && this.kv != null ? 1 : 0) != 0, (Object)"closed");
        return this.kv;
    }

    public synchronized SnapshotRocksDBKVStore snapshot() {
        Preconditions.checkState((this.db != null ? 1 : 0) != 0, (Object)"closed");
        return new SnapshotRocksDBKVStore(this.db);
    }

    public synchronized void mutate(Mutations mutations, boolean sync) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        Preconditions.checkState((this.db != null ? 1 : 0) != 0, (Object)"closed");
        try (WriteBatch batch = new WriteBatch();){
            try (ReadOptions iteratorOptions = new ReadOptions().setFillCache(false);){
                for (KeyRange range : mutations.getRemoveRanges()) {
                    byte[] min = range.getMin();
                    byte[] max = range.getMax();
                    if (min != null && max != null && ByteUtil.isConsecutive((byte[])min, (byte[])max)) {
                        batch.remove(min);
                        continue;
                    }
                    RocksDBKVStore.Iterator i = this.kv.createIterator(iteratorOptions, min, max, false);
                    Throwable throwable = null;
                    try {
                        while (i.hasNext()) {
                            batch.remove(i.next().getKey());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (i == null) continue;
                        if (throwable != null) {
                            try {
                                i.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        i.close();
                    }
                }
            }
            for (Map.Entry entry : mutations.getPutPairs()) {
                batch.put((byte[])entry.getKey(), (byte[])entry.getValue());
            }
            for (Map.Entry entry : mutations.getAdjustPairs()) {
                batch.merge((byte[])entry.getKey(), this.kv.encodeCounter((Long)entry.getValue()));
            }
            var6_9 = null;
            try (WriteOptions writeOptions = new WriteOptions().setSync(sync);){
                this.db.write(writeOptions, batch);
            }
            catch (Throwable throwable) {
                var6_9 = throwable;
                throw throwable;
            }
        }
        catch (RocksDBException e) {
            throw new RuntimeException("error applying changes to RocksDB", e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.db != null) {
                this.log.warn((Object)((Object)this) + " leaked without invoking stop()");
            }
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[dir=" + this.directory + ",kv=" + (Object)((Object)this.kv) + "]";
    }
}

