/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.rocksdb;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.NoSuchElementException;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.rocksdb.RocksDBUtil;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.CloseableTracker;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksObject;
import org.rocksdb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBKVStore
extends AbstractKVStore
implements CloseableKVStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final CloseableTracker cursorTracker = new CloseableTracker();
    private final ReadOptions readOptions;
    private final boolean closeReadOptions;
    private final WriteBatch writeBatch;
    private final RocksDB db;
    private volatile boolean closed;

    public RocksDBKVStore(RocksDB db) {
        this(db, null, null);
    }

    public RocksDBKVStore(RocksDB db, ReadOptions readOptions, WriteBatch writeBatch) {
        this(db, readOptions != null ? readOptions : new ReadOptions(), readOptions == null, writeBatch);
    }

    RocksDBKVStore(RocksDB db, ReadOptions readOptions, boolean closeReadOptions, WriteBatch writeBatch) {
        Preconditions.checkArgument((db != null ? 1 : 0) != 0, (Object)"null db");
        Preconditions.checkArgument((readOptions != null ? 1 : 0) != 0);
        assert (RocksDBUtil.isInitialized((RocksObject)db));
        assert (RocksDBUtil.isInitialized((RocksObject)readOptions));
        this.db = db;
        this.readOptions = readOptions;
        this.closeReadOptions = closeReadOptions;
        this.writeBatch = writeBatch;
        if (this.log.isTraceEnabled()) {
            this.log.trace("created " + (Object)((Object)this));
        }
    }

    public RocksDB getDB() {
        return this.db;
    }

    public byte[] get(byte[] key) {
        key.getClass();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        assert (RocksDBUtil.isInitialized((RocksObject)this.db));
        assert (RocksDBUtil.isInitialized((RocksObject)this.readOptions));
        this.cursorTracker.poll();
        try {
            return this.db.get(this.readOptions, key);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("RocksDB error", e);
        }
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        return this.createIterator(this.readOptions, minKey, maxKey, reverse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] key, byte[] value) {
        key.getClass();
        value.getClass();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        if (this.writeBatch != null) {
            assert (RocksDBUtil.isInitialized((RocksObject)this.writeBatch));
            WriteBatch writeBatch = this.writeBatch;
            synchronized (writeBatch) {
                this.writeBatch.put(key, value);
            }
        }
        assert (RocksDBUtil.isInitialized((RocksObject)this.db));
        try {
            this.db.put(key, value);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("RocksDB error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte[] key) {
        key.getClass();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        if (this.writeBatch != null) {
            assert (RocksDBUtil.isInitialized((RocksObject)this.writeBatch));
            WriteBatch writeBatch = this.writeBatch;
            synchronized (writeBatch) {
                this.writeBatch.remove(key);
            }
        }
        assert (RocksDBUtil.isInitialized((RocksObject)this.db));
        try {
            this.db.remove(key);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("RocksDB error", e);
        }
    }

    public byte[] encodeCounter(long value) {
        byte[] bytes = new byte[]{(byte)(value >> 0), (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
        return bytes;
    }

    public long decodeCounter(byte[] value) {
        Preconditions.checkArgument((value.length == 8 ? 1 : 0) != 0, (Object)"invalid encoded counter value length != 8");
        return (long)(value[7] & 0xFF) << 56 | (long)(value[6] & 0xFF) << 48 | (long)(value[5] & 0xFF) << 40 | (long)(value[4] & 0xFF) << 32 | (long)(value[3] & 0xFF) << 24 | (long)(value[2] & 0xFF) << 16 | (long)(value[1] & 0xFF) << 8 | (long)(value[0] & 0xFF) << 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustCounter(byte[] key, long amount) {
        key.getClass();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        byte[] value = this.encodeCounter(amount);
        if (this.writeBatch != null) {
            assert (RocksDBUtil.isInitialized((RocksObject)this.writeBatch));
            WriteBatch writeBatch = this.writeBatch;
            synchronized (writeBatch) {
                this.writeBatch.merge(key, value);
            }
        }
        assert (RocksDBUtil.isInitialized((RocksObject)this.db));
        try {
            this.db.merge(key, value);
        }
        catch (RocksDBException e) {
            throw new RuntimeException("RocksDB error", e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                this.log.warn((Object)((Object)this) + " leaked without invoking close()");
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[db=" + this.db + ",options=" + this.readOptions + (this.writeBatch != null ? ",writeBatch=" + this.writeBatch : "") + "]";
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace("closing " + (Object)((Object)this));
        }
        this.cursorTracker.close();
        if (this.closeReadOptions) {
            this.readOptions.close();
        }
    }

    Iterator createIterator(ReadOptions readOptions, byte[] minKey, byte[] maxKey, boolean reverse) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
        this.cursorTracker.poll();
        assert (RocksDBUtil.isInitialized((RocksObject)this.db));
        assert (RocksDBUtil.isInitialized((RocksObject)readOptions));
        assert (readOptions.snapshot() == null || RocksDBUtil.isInitialized((RocksObject)readOptions.snapshot()));
        return new Iterator(this.db.newIterator(readOptions), minKey, maxKey, reverse);
    }

    private static class CursorCloser
    implements Closeable {
        private final RocksIterator cursor;

        CursorCloser(RocksIterator cursor) {
            this.cursor = cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            RocksIterator rocksIterator = this.cursor;
            synchronized (rocksIterator) {
                if (RocksDBUtil.isInitialized((RocksObject)this.cursor)) {
                    try {
                        this.cursor.close();
                    }
                    catch (Throwable e) {
                        LoggerFactory.getLogger(this.getClass()).debug("caught exception closing db iterator (ignoring)", e);
                    }
                }
            }
        }
    }

    final class Iterator
    implements CloseableIterator<KVPair> {
        private final RocksIterator cursor;
        private final byte[] minKey;
        private final byte[] maxKey;
        private final boolean reverse;
        private KVPair next;
        private byte[] removeKey;
        private boolean finished;
        private boolean closed;

        private Iterator(RocksIterator cursor, byte[] minKey, byte[] maxKey, boolean reverse) {
            RocksDBKVStore.this.cursorTracker.add((Object)this, (Closeable)new CursorCloser(cursor));
            Preconditions.checkArgument((minKey == null || maxKey == null || ByteUtil.compare((byte[])minKey, (byte[])maxKey) <= 0 ? 1 : 0) != 0, (Object)"minKey > maxKey");
            assert (RocksDBUtil.isInitialized((RocksObject)cursor));
            this.cursor = cursor;
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.reverse = reverse;
            if (RocksDBKVStore.this.log.isTraceEnabled()) {
                RocksDBKVStore.this.log.trace("created " + this);
            }
            if (reverse) {
                if (maxKey != null) {
                    if (RocksDBKVStore.this.log.isTraceEnabled()) {
                        RocksDBKVStore.this.log.trace("seek to " + ByteUtil.toString((byte[])maxKey));
                    }
                    assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                    this.cursor.seek(maxKey);
                    if (this.cursor.isValid()) {
                        if (RocksDBKVStore.this.log.isTraceEnabled()) {
                            RocksDBKVStore.this.log.trace("valid, seek to previous before " + ByteUtil.toString((byte[])maxKey));
                        }
                        assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                        this.cursor.prev();
                    } else {
                        if (RocksDBKVStore.this.log.isTraceEnabled()) {
                            RocksDBKVStore.this.log.trace("not valid, seek to last");
                        }
                        assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                        this.cursor.seekToLast();
                    }
                } else {
                    if (RocksDBKVStore.this.log.isTraceEnabled()) {
                        RocksDBKVStore.this.log.trace("seek to last");
                    }
                    assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                    this.cursor.seekToLast();
                }
            } else if (minKey != null) {
                if (RocksDBKVStore.this.log.isTraceEnabled()) {
                    RocksDBKVStore.this.log.trace("seek to " + ByteUtil.toString((byte[])minKey));
                }
                assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                this.cursor.seek(minKey);
            } else {
                if (RocksDBKVStore.this.log.isTraceEnabled()) {
                    RocksDBKVStore.this.log.trace("seek to first");
                }
                assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                this.cursor.seekToFirst();
            }
            if (RocksDBKVStore.this.log.isTraceEnabled()) {
                assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                RocksDBKVStore.this.log.trace("starting position is " + (this.cursor.isValid() ? new KVPair(this.cursor.key(), this.cursor.value()) : "INVALID"));
            }
            assert (!this.cursor.isValid() || (!this.reverse ? minKey != null && ByteUtil.compare((byte[])this.cursor.key(), (byte[])minKey) >= 0 : maxKey == null || ByteUtil.compare((byte[])this.cursor.key(), (byte[])maxKey) < 0)) : "first key " + ByteUtil.toString((byte[])this.cursor.key()) + (reverse ? " >= " + ByteUtil.toString((byte[])maxKey) + " max key" : " < " + ByteUtil.toString((byte[])minKey) + " min key");
            this.updateFromCursor();
        }

        public synchronized boolean hasNext() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
            return this.next != null || this.findNext();
        }

        public synchronized KVPair next() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
            if (this.next == null && !this.findNext()) {
                throw new NoSuchElementException();
            }
            assert (this.next != null);
            KVPair pair = this.next;
            this.removeKey = pair.getKey();
            this.next = null;
            return pair;
        }

        public synchronized void remove() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"closed");
            Preconditions.checkState((this.removeKey != null ? 1 : 0) != 0);
            if (RocksDBKVStore.this.log.isTraceEnabled()) {
                RocksDBKVStore.this.log.trace("remove " + ByteUtil.toString((byte[])this.removeKey));
            }
            RocksDBKVStore.this.remove(this.removeKey);
            this.removeKey = null;
        }

        private boolean findNext() {
            assert (Thread.holdsLock(this));
            assert (!this.closed);
            assert (this.next == null);
            if (this.finished) {
                return false;
            }
            if (this.reverse) {
                assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                this.cursor.prev();
                if (RocksDBKVStore.this.log.isTraceEnabled()) {
                    assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                    RocksDBKVStore.this.log.trace("seek previous -> " + (this.cursor.isValid() ? new KVPair(this.cursor.key(), this.cursor.value()) : "START"));
                }
            } else {
                assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                this.cursor.next();
                if (RocksDBKVStore.this.log.isTraceEnabled()) {
                    assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
                    RocksDBKVStore.this.log.trace("seek next -> " + (this.cursor.isValid() ? new KVPair(this.cursor.key(), this.cursor.value()) : "END"));
                }
            }
            return this.updateFromCursor();
        }

        private boolean updateFromCursor() {
            assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
            if (!this.cursor.isValid()) {
                this.finished = true;
                return false;
            }
            assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
            byte[] key = this.cursor.key();
            assert (RocksDBUtil.isInitialized((RocksObject)this.cursor));
            byte[] value = this.cursor.value();
            if (this.reverse ? this.minKey != null && ByteUtil.compare((byte[])key, (byte[])this.minKey) < 0 : this.maxKey != null && ByteUtil.compare((byte[])key, (byte[])this.maxKey) >= 0) {
                if (RocksDBKVStore.this.log.isTraceEnabled()) {
                    RocksDBKVStore.this.log.trace("stop at bound " + ByteUtil.toString((byte[])(this.reverse ? this.minKey : this.maxKey)));
                }
                this.finished = true;
                return false;
            }
            this.next = new KVPair(key, value);
            return true;
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (RocksDBKVStore.this.log.isTraceEnabled()) {
                RocksDBKVStore.this.log.trace("closing " + this);
            }
            new CursorCloser(this.cursor).close();
        }

        public String toString() {
            return RocksDBKVStore.class.getSimpleName() + "." + this.getClass().getSimpleName() + "[minKey=" + ByteUtil.toString((byte[])this.minKey) + ",maxKey=" + ByteUtil.toString((byte[])this.maxKey) + (this.reverse ? ",reverse" : "") + "]";
        }
    }
}

