/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.rocksdb;

import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.rocksdb.RocksDBKVStore;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.Snapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotRocksDBKVStore
extends RocksDBKVStore
implements CloseableKVStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Snapshot snapshot;
    private boolean closed;

    public SnapshotRocksDBKVStore(RocksDB db) {
        this(db, db.getSnapshot());
    }

    private SnapshotRocksDBKVStore(RocksDB db, Snapshot snapshot) {
        super(db, new ReadOptions().setSnapshot(snapshot), true, null);
        this.snapshot = snapshot;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        try {
            this.snapshot.close();
        }
        catch (Throwable e) {
            this.log.error("caught exception closing RocksDB snapshot (ignoring)", e);
        }
    }

    @Override
    public void put(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    @Override
    public void remove(byte[] key) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    @Override
    public void adjustCounter(byte[] key, long amount) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }
}

