/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class AnnotatedClassScanner
extends ClassPathScanningCandidateComponentProvider {
    private static final ThreadLocal<ArrayList<Class<? extends Annotation>>> INIT_HACK = new ThreadLocal();
    private final ArrayList<Class<? extends Annotation>> annotationTypes;

    public AnnotatedClassScanner(Class<?> ... annotationTypes) {
        super(AnnotatedClassScanner.initHack(true, annotationTypes));
        this.setResourceLoader((ResourceLoader)new DefaultResourceLoader());
        this.annotationTypes = INIT_HACK.get();
        INIT_HACK.remove();
    }

    public AnnotatedClassScanner(boolean useDefaultFilters, Environment environment, Class<?> ... annotationTypes) {
        super(AnnotatedClassScanner.initHack(useDefaultFilters, annotationTypes), environment);
        this.annotationTypes = INIT_HACK.get();
        INIT_HACK.remove();
    }

    private static boolean initHack(boolean rtn, Class<?> ... annotationTypes) {
        Preconditions.checkArgument((annotationTypes != null && annotationTypes.length > 0 ? 1 : 0) != 0, (Object)"null/empty annotationTypes");
        ArrayList<Class<Annotation>> list = new ArrayList<Class<Annotation>>();
        for (Class<?> cl : annotationTypes) {
            try {
                list.add(cl.asSubclass(Annotation.class));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(cl + " is not an annotation type");
            }
        }
        INIT_HACK.set(list);
        return rtn;
    }

    public ArrayList<String> scanForClasses(String ... basePackages) {
        Preconditions.checkArgument((basePackages != null && basePackages.length > 0 ? 1 : 0) != 0, (Object)"at least one base package name is required");
        ArrayList<String> nameList = new ArrayList<String>();
        for (String basePackage : basePackages) {
            for (BeanDefinition candidate : this.findCandidateComponents(basePackage)) {
                nameList.add(candidate.getBeanClassName());
            }
        }
        return nameList;
    }

    protected void registerDefaultFilters() {
        for (Class<? extends Annotation> annotationType : this.annotationTypes != null ? this.annotationTypes : INIT_HACK.get()) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
        }
    }
}

