/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.spring.KVStoreHttpMessageConverter;
import org.jsimpledb.spring.SnapshotJTransactionHttpMessageConverter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class JObjectHttpMessageConverter
extends AbstractHttpMessageConverter<JObject> {
    public static final String ROOT_OBJECT_ID_PARAMETER_NAME = "root";
    private final JSimpleDB jdb;
    private Class<?>[] validationGroups;

    public JObjectHttpMessageConverter(JSimpleDB jdb) {
        super(SnapshotJTransactionHttpMessageConverter.MIME_TYPE);
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        this.jdb = jdb;
    }

    public void setValidationGroups(Class<?> ... groups) {
        this.validationGroups = groups;
    }

    protected Long getContentLength(JObject jobj, MediaType contentType) {
        return KVStoreHttpMessageConverter.getKVStoreContentLength((KVStore)jobj.getTransaction().getTransaction().getKVTransaction());
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return super.canRead(mediaType);
    }

    protected boolean supports(Class<?> target) {
        return this.jdb.findJClass(target) != null;
    }

    protected MediaType getDefaultContentType(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        return new MediaType(SnapshotJTransactionHttpMessageConverter.MIME_TYPE, Collections.singletonMap(ROOT_OBJECT_ID_PARAMETER_NAME, jobj.getObjId().toString()));
    }

    protected JObject readInternal(Class<? extends JObject> type, HttpInputMessage input) throws IOException {
        ObjId id;
        SnapshotJTransaction jtx = SnapshotJTransactionHttpMessageConverter.readSnapshotTransaction(this.jdb, input, this.validationGroups);
        MediaType mediaType = input.getHeaders().getContentType();
        if (!SnapshotJTransactionHttpMessageConverter.MIME_TYPE.includes(mediaType)) {
            throw new HttpMessageNotReadableException("invalid Content-Type `" + mediaType + "'");
        }
        String objId = mediaType.getParameter(ROOT_OBJECT_ID_PARAMETER_NAME);
        if (objId == null) {
            throw new HttpMessageNotReadableException("required parameter `root' missing from Content-Type `" + mediaType + "'");
        }
        try {
            id = new ObjId(objId);
        }
        catch (IllegalArgumentException e) {
            throw new HttpMessageNotReadableException("invalid `root' parameter value `" + objId + "' in Content-Type `" + mediaType + "'");
        }
        JObject jobj = jtx.get(id);
        if (!jobj.exists()) {
            throw new HttpMessageNotReadableException("no object with object ID " + id + " found in object graph");
        }
        return jobj;
    }

    protected void writeInternal(JObject jobj, HttpOutputMessage output) throws IOException {
        output.getHeaders().setContentType(this.getDefaultContentType(jobj));
        KVStoreHttpMessageConverter.writeKVStore((KVStore)jobj.getTransaction().getTransaction().getKVTransaction(), output);
    }
}

