/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import org.jsimpledb.JSimpleDB;
import org.jsimpledb.spring.JSimpleDBFactoryBean;
import org.jsimpledb.spring.ScanClassesBeanDefinitionParser;
import org.jsimpledb.spring.ScanFieldTypesBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class JSimpleDBBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String KVSTORE_ATTRIBUTE = "kvstore";
    private static final String SCHEMA_VERSION_ATTRIBUTE = "schema-version";
    private static final String STORAGE_ID_GENERATOR_ATTRIBUTE = "storage-id-generator";
    private static final String AUTO_GENERATE_STORAGE_IDS_ATTRIBUTE = "auto-generate-storage-ids";

    JSimpleDBBeanDefinitionParser() {
    }

    protected Class<JSimpleDB> getBeanClass(Element element) {
        return JSimpleDB.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        boolean autogenStorageIds;
        if (element.hasAttribute(KVSTORE_ATTRIBUTE)) {
            builder.addPropertyReference("KVStore", element.getAttribute(KVSTORE_ATTRIBUTE));
        }
        if (element.hasAttribute(SCHEMA_VERSION_ATTRIBUTE)) {
            builder.addPropertyValue("schemaVersion", (Object)element.getAttribute(SCHEMA_VERSION_ATTRIBUTE));
        }
        boolean bl = autogenStorageIds = !element.hasAttribute(AUTO_GENERATE_STORAGE_IDS_ATTRIBUTE) || Boolean.valueOf(element.getAttribute(AUTO_GENERATE_STORAGE_IDS_ATTRIBUTE)) != false;
        if (!autogenStorageIds) {
            builder.addPropertyValue("storageIdGenerator", null);
        }
        if (element.hasAttribute(STORAGE_ID_GENERATOR_ATTRIBUTE)) {
            if (!autogenStorageIds) {
                parserContext.getReaderContext().fatal("<" + element.getTagName() + "> cannot have a `" + STORAGE_ID_GENERATOR_ATTRIBUTE + "' attribute and " + AUTO_GENERATE_STORAGE_IDS_ATTRIBUTE + "=\"false\"", parserContext.extractSource((Object)element));
                return;
            }
            builder.addPropertyReference("storageIdGenerator", element.getAttribute(STORAGE_ID_GENERATOR_ATTRIBUTE));
        }
        builder.getRawBeanDefinition().setBeanClass(JSimpleDBFactoryBean.class);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element child;
            if (!(nodeList.item(i) instanceof Element) || !"http://jsimpledb.googlecode.com/schema/jsimpledb".equals((child = (Element)nodeList.item(i)).getNamespaceURI())) continue;
            if (child.getLocalName().equals("scan-classes")) {
                builder.addPropertyValue("modelClasses", (Object)new ScanClassesBeanDefinitionParser().parse(child, parserContext));
                continue;
            }
            if (child.getLocalName().equals("scan-field-types")) {
                builder.addPropertyValue("fieldTypeClasses", (Object)new ScanFieldTypesBeanDefinitionParser().parse(child, parserContext));
                continue;
            }
            parserContext.getReaderContext().fatal("unsupported <" + child.getTagName() + "> element found inside <" + element.getTagName() + "> element", parserContext.extractSource((Object)element));
            return;
        }
    }
}

