/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import com.google.common.base.Preconditions;
import org.jsimpledb.DefaultStorageIdGenerator;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleDBFactory;
import org.jsimpledb.StorageIdGenerator;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.simple.SimpleKVDatabase;
import org.springframework.beans.factory.config.AbstractFactoryBean;

class JSimpleDBFactoryBean
extends AbstractFactoryBean<JSimpleDB> {
    private KVDatabase kvstore;
    private int schemaVersion;
    private StorageIdGenerator storageIdGenerator = new DefaultStorageIdGenerator();
    private Iterable<? extends Class<?>> modelClasses;
    private Iterable<? extends Class<? extends FieldType<?>>> fieldTypeClasses;

    JSimpleDBFactoryBean() {
    }

    public void setKVStore(KVDatabase kvstore) {
        this.kvstore = kvstore;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setStorageIdGenerator(StorageIdGenerator storageIdGenerator) {
        this.storageIdGenerator = storageIdGenerator;
    }

    public void setModelClasses(Iterable<? extends Class<?>> modelClasses) {
        this.modelClasses = modelClasses;
    }

    public void setFieldTypeClasses(Iterable<? extends Class<? extends FieldType<?>>> fieldTypeClasses) {
        this.fieldTypeClasses = fieldTypeClasses;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Preconditions.checkState((this.modelClasses != null ? 1 : 0) != 0, (Object)"no modelClasss configured");
    }

    public Class<?> getObjectType() {
        return JSimpleDB.class;
    }

    protected JSimpleDB createInstance() {
        KVDatabase kvstore1 = this.kvstore;
        int schemaVersion1 = this.schemaVersion;
        if (kvstore1 == null) {
            kvstore1 = new SimpleKVDatabase();
            if (schemaVersion1 == 0) {
                schemaVersion1 = 1;
            }
        }
        Database db = new Database(kvstore1);
        if (this.fieldTypeClasses != null) {
            db.getFieldTypeRegistry().addClasses(this.fieldTypeClasses);
        }
        return new JSimpleDBFactory().setDatabase(db).setSchemaVersion(schemaVersion1).setStorageIdGenerator(this.storageIdGenerator).setModelClasses(this.modelClasses).newJSimpleDB();
    }
}

