/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.core.DatabaseException;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.TransactionTimedOutException;
import org.springframework.transaction.TransactionUsageException;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronization;

public class JSimpleDBTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    public static final String ISOLATION_OPTION = Isolation.class.getName();
    public static final ValidationMode DEFAULT_VALIDATION_MODE = ValidationMode.AUTOMATIC;
    protected transient JSimpleDB jdb;
    protected boolean allowNewSchema = true;
    protected ValidationMode validationMode = DEFAULT_VALIDATION_MODE;
    private boolean validateBeforeCommit;

    public void afterPropertiesSet() throws Exception {
        if (this.jdb == null) {
            throw new Exception("no JSimpleDB configured");
        }
    }

    public void setJSimpleDB(JSimpleDB jdb) {
        this.jdb = jdb;
    }

    public void setAllowNewSchema(boolean allowNewSchema) {
        this.allowNewSchema = allowNewSchema;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode != null ? validationMode : DEFAULT_VALIDATION_MODE;
    }

    public void setValidateBeforeCommit(boolean validateBeforeCommit) {
        this.validateBeforeCommit = validateBeforeCommit;
    }

    public Object getResourceFactory() {
        return this.jdb;
    }

    protected Object doGetTransaction() {
        return new TxWrapper(this.getCurrent());
    }

    protected boolean isExistingTransaction(Object txObj) {
        return ((TxWrapper)txObj).getJTransaction() != null;
    }

    protected void doBegin(Object txObj, TransactionDefinition txDef) {
        JTransaction jtx;
        TxWrapper tx = (TxWrapper)txObj;
        if (tx.getJTransaction() != null) {
            throw new TransactionUsageException("there is already a transaction associated with the current thread");
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        switch (txDef.getIsolationLevel()) {
            case 1: {
                options.put(ISOLATION_OPTION, Isolation.READ_UNCOMMITTED);
                break;
            }
            case 2: {
                options.put(ISOLATION_OPTION, Isolation.READ_COMMITTED);
                break;
            }
            case 4: {
                options.put(ISOLATION_OPTION, Isolation.REPEATABLE_READ);
                break;
            }
            case 8: {
                options.put(ISOLATION_OPTION, Isolation.SERIALIZABLE);
                break;
            }
            case -1: {
                options.put(ISOLATION_OPTION, Isolation.DEFAULT);
                break;
            }
            default: {
                this.logger.warn((Object)("unexpected isolation level " + txDef.getIsolationLevel()));
            }
        }
        try {
            jtx = this.createTransaction(options);
        }
        catch (DatabaseException e) {
            throw new CannotCreateTransactionException("error creating new JSimpleDB transaction", (Throwable)e);
        }
        boolean succeeded = false;
        try {
            this.configureTransaction(jtx, txDef);
            JTransaction.setCurrent((JTransaction)jtx);
            succeeded = true;
        }
        catch (DatabaseException e) {
            throw new CannotCreateTransactionException("error configuring JSimpleDB transaction", (Throwable)e);
        }
        finally {
            if (!succeeded) {
                JTransaction.setCurrent(null);
                try {
                    jtx.rollback();
                }
                catch (DatabaseException databaseException) {}
            }
        }
        tx.setJTransaction(jtx);
    }

    protected JTransaction createTransaction(Map<String, Object> options) {
        return this.jdb.createTransaction(this.allowNewSchema, this.validationMode, options);
    }

    protected Object doSuspend(Object txObj) {
        JTransaction jtx = ((TxWrapper)txObj).getJTransaction();
        if (jtx == null) {
            throw new TransactionUsageException("no JTransaction exists in the provided transaction object");
        }
        if (jtx != this.getCurrent()) {
            throw new TransactionUsageException("the provided transaction object contains the wrong JTransaction");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("suspending current JSimpleDB transaction " + jtx));
        }
        JTransaction.setCurrent(null);
        return jtx;
    }

    protected void doResume(Object txObj, Object suspendedResources) {
        if (this.getCurrent() != null) {
            throw new TransactionUsageException("there is already a transaction associated with the current thread");
        }
        JTransaction jtx = (JTransaction)suspendedResources;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("resuming JSimpleDB transaction " + jtx));
        }
        JTransaction.setCurrent((JTransaction)jtx);
    }

    protected void configureTransaction(JTransaction jtx, TransactionDefinition txDef) {
        block4: {
            int timeout;
            if (txDef.isReadOnly()) {
                jtx.getTransaction().setReadOnly(true);
            }
            if ((timeout = this.determineTimeout(txDef)) != -1) {
                try {
                    jtx.getTransaction().setTimeout((long)timeout * 1000L);
                }
                catch (UnsupportedOperationException e) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)("setting non-default timeout of " + timeout + "sec not supported by underlying transaction"));
                }
            }
        }
    }

    protected void prepareForCommit(DefaultTransactionStatus status) {
        if (!status.hasTransaction()) {
            return;
        }
        JTransaction jtx = ((TxWrapper)status.getTransaction()).getJTransaction();
        if (jtx == null) {
            throw new NoTransactionException("no current JTransaction exists");
        }
        if (this.validateBeforeCommit) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("triggering validation prior to commit of JSimpleDB transaction " + jtx));
            }
            jtx.validate();
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        if (!status.hasTransaction()) {
            return;
        }
        JTransaction jtx = ((TxWrapper)status.getTransaction()).getJTransaction();
        if (jtx == null) {
            throw new NoTransactionException("no current JTransaction exists");
        }
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("committing JSimpleDB transaction " + jtx));
            }
            jtx.commit();
        }
        catch (RetryTransactionException e) {
            throw new PessimisticLockingFailureException("transaction must be retried", (Throwable)e);
        }
        catch (StaleTransactionException e) {
            throw new TransactionTimedOutException("transaction is no longer usable", (Throwable)e);
        }
        catch (DatabaseException e) {
            throw new TransactionSystemException("error committing transaction", (Throwable)e);
        }
        finally {
            JTransaction.setCurrent(null);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        if (!status.hasTransaction()) {
            return;
        }
        JTransaction jtx = ((TxWrapper)status.getTransaction()).getJTransaction();
        if (jtx == null) {
            throw new NoTransactionException("no current JTransaction exists");
        }
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("rolling back JSimpleDB transaction " + jtx));
            }
            jtx.rollback();
        }
        catch (StaleTransactionException e) {
            throw new TransactionTimedOutException("transaction is no longer usable", (Throwable)e);
        }
        catch (DatabaseException e) {
            throw new TransactionSystemException("error committing transaction", (Throwable)e);
        }
        finally {
            JTransaction.setCurrent(null);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        if (!status.hasTransaction()) {
            return;
        }
        JTransaction jtx = ((TxWrapper)status.getTransaction()).getJTransaction();
        if (jtx == null) {
            throw new NoTransactionException("no current JTransaction exists");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("marking JSimpleDB transaction " + jtx + " for rollback-only"));
        }
        jtx.getTransaction().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object txObj) {
        JTransaction.setCurrent(null);
    }

    protected void registerAfterCompletionWithExistingTransaction(Object txObj, List<TransactionSynchronization> synchronizations) {
        JTransaction jtx = ((TxWrapper)txObj).getJTransaction();
        if (jtx == null) {
            throw new NoTransactionException("no current JTransaction exists");
        }
        Transaction tx = jtx.getTransaction();
        for (TransactionSynchronization synchronization : synchronizations) {
            tx.addCallback((Transaction.Callback)new TransactionSynchronizationCallback(synchronization));
        }
    }

    protected JTransaction getCurrent() {
        try {
            return JTransaction.getCurrent();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static class TransactionSynchronizationCallback
    implements Transaction.Callback {
        protected final TransactionSynchronization synchronization;

        public TransactionSynchronizationCallback(TransactionSynchronization synchronization) {
            Preconditions.checkArgument((synchronization != null ? 1 : 0) != 0, (Object)"null synchronization");
            this.synchronization = synchronization;
        }

        public void beforeCommit(boolean readOnly) {
            this.synchronization.beforeCommit(readOnly);
        }

        public void beforeCompletion() {
            this.synchronization.beforeCompletion();
        }

        public void afterCommit() {
            this.synchronization.afterCommit();
        }

        public void afterCompletion(boolean committed) {
            this.synchronization.afterCompletion(committed ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TransactionSynchronizationCallback that = (TransactionSynchronizationCallback)obj;
            return this.synchronization.equals(that.synchronization);
        }

        public int hashCode() {
            return this.synchronization.hashCode();
        }
    }

    private static class TxWrapper
    implements SmartTransactionObject {
        private JTransaction jtx;

        TxWrapper(JTransaction jtx) {
            this.jtx = jtx;
        }

        public JTransaction getJTransaction() {
            return this.jtx;
        }

        public void setJTransaction(JTransaction jtx) {
            this.jtx = jtx;
        }

        public boolean isRollbackOnly() {
            return this.jtx != null && this.jtx.getTransaction().isRollbackOnly();
        }

        public void flush() {
        }
    }
}

