/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import com.google.common.base.Throwables;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ValidationMode;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenTransactionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_JSIMPLEDB_BEAN_NAME = "jsimpledb";
    public static final String JSIMPLEDB_BEAN_NAME_PARAMETER = "JSimpleDBBeanName";
    public static final String JSIMPLEDB_TRANSACTION_ATTRIBUTE_PARAMETER = "transactionAttributes";
    public static final String JSIMPLEDB_ALLOW_NEW_SCHEMA_PARAMETER = "allowNewSchema";
    public static final String JSIMPLEDB_VALIDATION_MODE_PARAMETER = "validationMode";
    private String jsimpledbBeanName = "jsimpledb";
    private TransactionAttribute transactionAttributes;
    private boolean allowNewSchema;
    private ValidationMode validationMode = ValidationMode.AUTOMATIC;
    private volatile JSimpleDB jdb;

    public String getJSimpleDBBeanName() {
        return this.jsimpledbBeanName;
    }

    public void setJSimpleDBBeanName(String jsimpledbBeanName) {
        this.jsimpledbBeanName = jsimpledbBeanName;
    }

    public TransactionAttribute getTransactionAttributes() {
        return this.transactionAttributes;
    }

    public void setTransactionAttributes(TransactionAttribute transactionAttributes) {
        this.transactionAttributes = transactionAttributes;
    }

    public boolean isAllowNewSchema() {
        return this.allowNewSchema;
    }

    public void setAllowNewSchema(boolean allowNewSchema) {
        this.allowNewSchema = allowNewSchema;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        if (validationMode == null) {
            validationMode = ValidationMode.AUTOMATIC;
        }
        this.validationMode = validationMode;
    }

    protected JSimpleDB lookupJSimpleDB() {
        if (this.jdb == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            this.jdb = (JSimpleDB)wac.getBean(this.getJSimpleDBBeanName(), JSimpleDB.class);
        }
        return this.jdb;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            JTransaction.getCurrent();
            throw new IllegalStateException("a JTransaction is already associated with the current thread");
        }
        catch (IllegalStateException illegalStateException) {
            int timeout;
            TransactionAttribute attr = this.transactionAttributes;
            if (attr == null) {
                attr = new DefaultTransactionAttribute();
            }
            JTransaction jtx = this.lookupJSimpleDB().createTransaction(this.allowNewSchema, this.validationMode);
            if (attr.isReadOnly()) {
                jtx.getTransaction().setReadOnly(true);
            }
            if ((timeout = attr.getTimeout()) != -1) {
                try {
                    jtx.getTransaction().setTimeout((long)timeout * 1000L);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            boolean success = false;
            try {
                JTransaction.setCurrent((JTransaction)jtx);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                success = true;
            }
            catch (Throwable t) {
                if (attr.rollbackOn(t) || jtx.getTransaction().isRollbackOnly()) {
                    jtx.rollback();
                } else {
                    jtx.commit();
                }
                Throwables.propagateIfPossible((Throwable)t, ServletException.class, IOException.class);
                throw new RuntimeException(t);
            }
            finally {
                JTransaction.setCurrent(null);
                if (success) {
                    if (jtx.getTransaction().isRollbackOnly()) {
                        jtx.rollback();
                    } else {
                        jtx.commit();
                    }
                }
            }
            return;
        }
    }
}

