/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import java.util.ArrayList;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.ComponentScanBeanDefinitionParser;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class ScanClassPathBeanDefinitionParser
extends ComponentScanBeanDefinitionParser {
    private static final String BASE_PACKAGE_ATTRIBUTE = "base-package";
    private static final String RESOURCE_PATTERN_ATTRIBUTE = "resource-pattern";
    private static final String USE_DEFAULT_FILTERS_ATTRIBUTE = "use-default-filters";
    private static final String EXCLUDE_FILTER_ELEMENT = "exclude-filter";
    private static final String INCLUDE_FILTER_ELEMENT = "include-filter";

    ScanClassPathBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        XmlReaderContext readerContext = parserContext.getReaderContext();
        ClassLoader classLoader = readerContext.getResourceLoader().getClassLoader();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(this.getBeanClass());
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().getScope());
        }
        if (parserContext.isDefaultLazyInit()) {
            builder.setLazyInit(true);
        }
        builder.addPropertyValue("basePackages", (Object)StringUtils.tokenizeToStringArray((String)element.getAttribute(BASE_PACKAGE_ATTRIBUTE), (String)",; \t\n"));
        if (element.hasAttribute(USE_DEFAULT_FILTERS_ATTRIBUTE)) {
            builder.addPropertyValue("useDefaultFilters", (Object)element.getAttribute(USE_DEFAULT_FILTERS_ATTRIBUTE));
        }
        if (element.hasAttribute(RESOURCE_PATTERN_ATTRIBUTE)) {
            builder.addPropertyValue("resourcePattern", (Object)element.getAttribute(RESOURCE_PATTERN_ATTRIBUTE));
        }
        ArrayList<TypeFilter> includeFilters = new ArrayList<TypeFilter>();
        ArrayList<TypeFilter> excludeFilters = new ArrayList<TypeFilter>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String localName = parserContext.getDelegate().getLocalName(node);
            Element childElement = (Element)node;
            try {
                if (INCLUDE_FILTER_ELEMENT.equals(localName)) {
                    includeFilters.add(this.createTypeFilter(childElement, classLoader, parserContext));
                }
                if (!EXCLUDE_FILTER_ELEMENT.equals(localName)) continue;
                excludeFilters.add(this.createTypeFilter(childElement, classLoader, parserContext));
                continue;
            }
            catch (Exception e) {
                readerContext.error(e.getMessage(), readerContext.extractSource((Object)element), e.getCause());
            }
        }
        builder.addPropertyValue("includeFilters", includeFilters);
        builder.addPropertyValue("excludeFilters", excludeFilters);
        return builder.getBeanDefinition();
    }

    abstract Class<?> getBeanClass();
}

