/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Set;
import org.dellroad.stuff.validation.ValidationUtil;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.ValidationException;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.util.NavigableMapKVStore;
import org.jsimpledb.spring.KVStoreHttpMessageConverter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class SnapshotJTransactionHttpMessageConverter
extends AbstractHttpMessageConverter<SnapshotJTransaction> {
    public static final MediaType MIME_TYPE = new MediaType("application", "x-jsimpledb-transaction");
    private final JSimpleDB jdb;
    private Class<?>[] validationGroups;

    public SnapshotJTransactionHttpMessageConverter(JSimpleDB jdb) {
        super(MIME_TYPE);
        Preconditions.checkArgument((jdb != null ? 1 : 0) != 0, (Object)"null jdb");
        this.jdb = jdb;
    }

    public void setValidationGroups(Class<?> ... groups) {
        this.validationGroups = groups;
    }

    protected Long getContentLength(SnapshotJTransaction jtx, MediaType contentType) {
        return KVStoreHttpMessageConverter.getKVStoreContentLength(jtx.getTransaction().getKVStore());
    }

    protected boolean supports(Class<?> clazz) {
        return clazz == SnapshotJTransaction.class;
    }

    protected SnapshotJTransaction readInternal(Class<? extends SnapshotJTransaction> clazz, HttpInputMessage input) throws IOException {
        return clazz.cast(SnapshotJTransactionHttpMessageConverter.readSnapshotTransaction(this.jdb, input, this.validationGroups));
    }

    protected void writeInternal(SnapshotJTransaction jtx, HttpOutputMessage output) throws IOException {
        KVStoreHttpMessageConverter.writeKVStore(jtx.getTransaction().getKVStore(), output);
    }

    static SnapshotJTransaction readSnapshotTransaction(JSimpleDB jdb, HttpInputMessage input, Class<?>[] validationGroups) throws IOException {
        NavigableMapKVStore kvstore = new NavigableMapKVStore();
        KVStoreHttpMessageConverter.readKVStore((KVStore)kvstore, input);
        SnapshotJTransaction jtx = jdb.createSnapshotTransaction((KVStore)kvstore, true, validationGroups != null ? ValidationMode.MANUAL : ValidationMode.DISABLED);
        if (validationGroups != null) {
            for (JObject jobj : jtx.getAll(JObject.class)) {
                jobj.revalidate((Class[])validationGroups);
            }
            try {
                jtx.validate();
            }
            catch (ValidationException e) {
                throw new HttpMessageNotReadableException("incoming object graph failed validation: " + ValidationUtil.describe((Set)e.getViolations()));
            }
        }
        return jtx;
    }
}

