/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.Deliver;
import org.atmosphere.util.ExecutorsFactory;

public class SimpleBroadcaster
extends DefaultBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBroadcaster.class);

    @Override
    public Broadcaster initialize(String id, AtmosphereConfig config) {
        return super.initialize(id, config);
    }

    @Override
    protected BroadcasterConfig createBroadcasterConfig(AtmosphereConfig config) {
        BroadcasterConfig bc = (BroadcasterConfig)config.properties().get(BroadcasterConfig.class.getName());
        if (bc == null) {
            bc = new BroadcasterConfig(config.framework().broadcasterFilters(), config, false, this.getID()).init().setScheduledExecutorService(ExecutorsFactory.getScheduler(config));
        }
        return bc;
    }

    @Override
    protected void start() {
        if (!this.started.getAndSet(true)) {
            this.setID(this.name);
            this.bc.getBroadcasterCache().start();
        }
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
        bc.setExecutorService(null, false).setAsyncWriteService(null, false).setScheduledExecutorService(ExecutorsFactory.getScheduler(this.config));
    }

    @Override
    public Future<Object> broadcast(Object msg) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used");
            return this.futureDone(msg);
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.push(new Deliver(newMsg, f, msg));
        return f;
    }

    @Override
    public Future<Object> broadcast(Object msg, AtmosphereResource r) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used");
            return this.futureDone(msg);
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.push(new Deliver(newMsg, r, f, msg));
        return f;
    }

    @Override
    public Future<Object> broadcast(Object msg, Set<AtmosphereResource> subset) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used");
            return this.futureDone(msg);
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.push(new Deliver(newMsg, subset, f, msg));
        return f;
    }

    @Override
    protected void prepareInvokeOnStateChange(AtmosphereResource r, AtmosphereResourceEvent e) {
        if (this.writeTimeoutInSecond != -1) {
            logger.warn("{} not supported with this broadcaster.", (Object)"org.atmosphere.cpr.Broadcaster.writeTimeout");
        }
        this.invokeOnStateChange(r, e);
    }

    @Override
    protected void queueWriteIO(AtmosphereResource r, Deliver deliver, AtomicInteger count) throws InterruptedException {
        this.executeBlockingWrite(r, deliver, count);
    }
}

