/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.spring;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.util.KeyListEncoder;
import org.jsimpledb.kv.util.NavigableMapKVStore;
import org.jsimpledb.util.CloseableIterator;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class KVStoreHttpMessageConverter
extends AbstractHttpMessageConverter<KVStore> {
    public static final MediaType DEFAULT_MIME_TYPE = new MediaType("application", "x-jsimpledb-kvstore");

    public KVStoreHttpMessageConverter() {
        super(DEFAULT_MIME_TYPE);
    }

    public KVStoreHttpMessageConverter(MediaType ... mimeTypes) {
        super(mimeTypes);
    }

    protected Long getContentLength(KVStore kvstore, MediaType mediaType) {
        return KVStoreHttpMessageConverter.getKVStoreContentLength(kvstore);
    }

    protected boolean supports(Class<?> clazz) {
        return clazz == KVStore.class || clazz == NavigableMapKVStore.class;
    }

    protected KVStore readInternal(Class<? extends KVStore> clazz, HttpInputMessage input) throws IOException {
        NavigableMapKVStore kvstore = new NavigableMapKVStore();
        KVStoreHttpMessageConverter.readKVStore((KVStore)kvstore, input);
        return clazz.cast(kvstore);
    }

    protected void writeInternal(KVStore kvstore, HttpOutputMessage output) throws IOException {
        KVStoreHttpMessageConverter.writeKVStore(kvstore, output);
    }

    public static Long getKVStoreContentLength(KVStore kvstore) {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        try (CloseableIterator i = kvstore.getRange(null, null);){
            Long l = KeyListEncoder.writePairsLength((Iterator)i);
            return l;
        }
    }

    public static void readKVStore(KVStore kvstore, HttpInputMessage input) throws IOException {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"null input");
        try {
            Iterator i = KeyListEncoder.readPairs((InputStream)input.getBody());
            while (i.hasNext()) {
                KVPair kv = (KVPair)i.next();
                kvstore.put(kv.getKey(), kv.getValue());
            }
        }
        catch (IllegalArgumentException e) {
            throw new HttpMessageNotReadableException("invalid endoded key/value store", (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static void writeKVStore(KVStore kvstore, HttpOutputMessage output) throws IOException {
        Preconditions.checkArgument((kvstore != null ? 1 : 0) != 0, (Object)"null kvstore");
        Preconditions.checkArgument((output != null ? 1 : 0) != 0, (Object)"null output");
        try (CloseableIterator i = kvstore.getRange(null, null);){
            KeyListEncoder.writePairs((Iterator)i, (OutputStream)output.getBody());
        }
    }
}

