/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.rocksdb;

import java.io.File;
import java.util.ArrayDeque;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.rocksdb.RocksDBAtomicKVStore;
import org.jsimpledb.kv.rocksdb.RocksDBKVDatabase;

public class RocksDBKVImplementation
extends KVImplementation {
    public String[][] getCommandLineOptions() {
        return new String[][]{{"--rocksdb directory", "Use RocksDB key/value database in the specified directory"}};
    }

    public File parseCommandLineOptions(ArrayDeque<String> options) {
        String arg = this.parseCommandLineOption(options, "--rocksdb");
        return arg != null ? new File(arg) : null;
    }

    public RocksDBKVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        RocksDBKVDatabase rocksdb = new RocksDBKVDatabase();
        rocksdb.setKVStore(this.createAtomicKVStore(configuration));
        return rocksdb;
    }

    public RocksDBAtomicKVStore createAtomicKVStore(Object configuration) {
        RocksDBAtomicKVStore kvstore = new RocksDBAtomicKVStore();
        kvstore.setDirectory((File)configuration);
        return kvstore;
    }

    public String getDescription(Object configuration) {
        return "RocksDB " + ((File)configuration).getName();
    }
}

