/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.spanner;

import com.google.cloud.WaitForOption;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.Operation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.spanner.ReadOnlySpannerView;
import org.jsimpledb.kv.spanner.SpannerKVTransaction;
import org.jsimpledb.util.MovingAverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SpannerKVDatabase
implements KVDatabase {
    public static final String OPTION_TIMESTAMP_BOUND = "TimestampBound";
    public static final String DEFAULT_DATABASE_ID = "jsimpledb";
    public static final String DEFAULT_TABLE_NAME = "KV";
    public static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final String INSTANCE_ID_PATTERN = "[a-z][-_A-Za-z0-9]*[a-z0-9]";
    private static final String DATABASE_ID_PATTERN = "[a-z][-_A-Za-z0-9]*[a-z0-9]";
    private static final String TABLE_NAME_PATTERN = "[A-Za-z][_A-Za-z0-9]*";
    private static final int INITIAL_RTT_ESTIMATE_MILLIS = 50;
    private static final double RTT_ESTIMATE_DECAY_FACTOR = 0.025;
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @GuardedBy(value="this")
    private Spanner spanner;
    @GuardedBy(value="this")
    private DatabaseClient client;
    @GuardedBy(value="this")
    private ExecutorService executor;
    @GuardedBy(value="this")
    private SpannerOptions spannerOptions;
    @GuardedBy(value="this")
    private String instanceId;
    @GuardedBy(value="this")
    private String databaseId = "jsimpledb";
    @GuardedBy(value="this")
    private String tableName = "KV";
    @GuardedBy(value="this")
    private int threadPoolSize = 10;
    @GuardedBy(value="this")
    private MovingAverage rtt;

    public synchronized void setSpannerOptions(SpannerOptions spannerOptions) {
        Preconditions.checkArgument((spannerOptions != null ? 1 : 0) != 0, (Object)"null spannerOptions");
        Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"already started");
        this.spannerOptions = spannerOptions;
    }

    public synchronized void setInstanceId(String instanceId) {
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"null instanceId");
        Preconditions.checkArgument((boolean)Pattern.compile("[a-z][-_A-Za-z0-9]*[a-z0-9]").matcher(instanceId).matches(), (Object)"invalid instanceId");
        Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"already started");
        this.instanceId = instanceId;
    }

    public synchronized void setDatabaseId(String databaseId) {
        Preconditions.checkArgument((databaseId != null ? 1 : 0) != 0, (Object)"null databaseId");
        Preconditions.checkArgument((boolean)Pattern.compile("[a-z][-_A-Za-z0-9]*[a-z0-9]").matcher(databaseId).matches(), (Object)"invalid databaseId");
        Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"already started");
        this.databaseId = databaseId;
    }

    public synchronized void setTableName(String tableName) {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"null tableName");
        Preconditions.checkArgument((boolean)Pattern.compile(TABLE_NAME_PATTERN).matcher(tableName).matches(), (Object)"invalid tableName");
        Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"already started");
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public synchronized void start() {
        if (this.spanner != null) {
            return;
        }
        Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"no instance ID configured");
        if (this.spannerOptions == null) {
            this.spannerOptions = SpannerOptions.newBuilder().build();
        }
        this.spanner = (Spanner)this.spannerOptions.getService();
        boolean success = false;
        try {
            Instance instance = this.setupInstance(this.spanner.getInstanceAdminClient());
            Database database = this.setupDatabase(instance);
            this.setupTable(database);
            DatabaseId did = DatabaseId.of((InstanceId)instance.getId(), (String)this.databaseId);
            this.client = this.spanner.getDatabaseClient(did);
            this.executor = Executors.newFixedThreadPool(this.threadPoolSize, r -> {
                Thread thread = new Thread(r);
                thread.setName(this.getClass().getSimpleName() + "-" + THREAD_COUNTER.incrementAndGet());
                return thread;
            });
            this.rtt = new MovingAverage(0.025, 50.0);
            success = true;
        }
        finally {
            if (!success) {
                this.cleanup();
            }
        }
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.spanner == null) {
            return;
        }
        this.cleanup();
    }

    private synchronized void cleanup() {
        if (this.spanner != null) {
            this.spanner.closeAsync();
            this.spanner = null;
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.executor = null;
        }
        this.client = null;
    }

    public synchronized int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public synchronized void setThreadPoolSize(int threadPoolSize) {
        Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize <= 0");
        Preconditions.checkState((this.spanner == null ? 1 : 0) != 0, (Object)"already started");
        this.threadPoolSize = threadPoolSize;
    }

    public synchronized double getRttEstimate() {
        Preconditions.checkState((this.rtt != null ? 1 : 0) != 0, (Object)"instance has never started");
        return this.rtt.get();
    }

    synchronized void updateRttEstimate(double rtt) {
        this.rtt.add(rtt);
    }

    private Instance setupInstance(InstanceAdminClient instanceAdminClient) {
        this.log.debug("finding spanner instance with ID \"" + this.instanceId + "\"");
        Instance instance = instanceAdminClient.getInstance(this.instanceId);
        this.log.debug("found spanner instance with ID \"" + this.instanceId + "\"");
        return instance;
    }

    private Database setupDatabase(Instance instance) {
        this.log.debug("finding spanner database with ID \"" + this.databaseId + "\"");
        try {
            Database database = instance.getDatabase(this.databaseId);
            this.log.debug("found spanner database with ID \"" + this.databaseId + "\"");
            return database;
        }
        catch (SpannerException e) {
            if (!ErrorCode.NOT_FOUND.equals((Object)e.getErrorCode())) {
                throw e;
            }
            this.log.debug("spanner database with ID \"" + this.databaseId + "\" not found");
            this.log.info("creating new spanner database with ID \"" + this.instanceId + "\"");
            return (Database)this.waitFor(instance.createDatabase(this.databaseId, Collections.singleton(this.getCreateTableDDL())));
        }
    }

    private void setupTable(Database database) {
        this.log.debug("finding key/value database table with name \"" + this.tableName + "\"");
        String expectedDDL = this.normalizeDDL(this.getCreateTableDDL());
        for (String statement : database.getDdl()) {
            if (!this.normalizeDDL(statement).equals(expectedDDL)) continue;
            this.log.debug("found key/value database table with name \"" + this.tableName + "\"");
            return;
        }
        this.log.debug("key/value database table with name \"" + this.tableName + "\" not found");
        String ddl = this.getCreateTableDDL();
        this.log.info("creating new key/value database table with name \"" + this.tableName + "\":\n" + ddl);
        this.waitFor(database.updateDdl(Collections.singleton(ddl), null));
    }

    private String getCreateTableDDL() {
        return "CREATE TABLE " + this.tableName + " (\n  key BYTES(MAX) NOT NULL,\n  val BYTES(MAX) NOT NULL,\n) PRIMARY KEY(key)";
    }

    private String normalizeDDL(String ddl) {
        return ddl.trim().replaceAll("([^-_A-Za-z0-9])\\s+([^-_A-Za-z0-9])", "$1$2").replaceAll("\\s+", " ").toLowerCase();
    }

    private <T> T waitFor(Operation<T, ?> operation) {
        return (T)operation.waitFor(new WaitForOption[]{WaitForOption.checkEvery((long)500L, (TimeUnit)TimeUnit.MILLISECONDS)}).getResult();
    }

    public SpannerKVTransaction createTransaction() {
        return this.createTransaction((Map)null);
    }

    public SpannerKVTransaction createTransaction(Map<String, ?> options) {
        TimestampBound consistency = TimestampBound.strong();
        if (options != null) {
            Object isolation = options.get("org.springframework.transaction.annotation.Isolation");
            if (isolation instanceof Enum) {
                isolation = ((Enum)isolation).name();
            }
            if (isolation != null) {
                switch (isolation.toString()) {
                    case "READ_COMMITTED": {
                        consistency = TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS);
                        break;
                    }
                    case "REPEATABLE_READ": {
                        consistency = TimestampBound.ofExactStaleness((long)3L, (TimeUnit)TimeUnit.SECONDS);
                        break;
                    }
                    case "SERIALIZABLE": {
                        consistency = TimestampBound.strong();
                        break;
                    }
                }
            }
            try {
                Object value = options.get(OPTION_TIMESTAMP_BOUND);
                if (value instanceof TimestampBound) {
                    consistency = (TimestampBound)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.createTransaction(consistency);
    }

    protected synchronized SpannerKVTransaction createTransaction(TimestampBound consistency) {
        Preconditions.checkState((this.spanner != null ? 1 : 0) != 0, (Object)"instance is not started");
        return new SpannerKVTransaction(this, this.client, this.tableName, consistency);
    }

    protected synchronized ExecutorService getExecutorService() {
        return this.executor;
    }

    public synchronized ReadOnlySpannerView snapshot(TimestampBound consistency) {
        Preconditions.checkState((this.spanner != null ? 1 : 0) != 0, (Object)"instance is not started");
        return new ReadOnlySpannerView(this.tableName, (ReadContext)this.client.readOnlyTransaction(consistency));
    }
}

