/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ParseContext;

public abstract class AbstractKVCommand
extends AbstractCommand {
    public static final Pattern CSTRING_PATTERN = Pattern.compile("\"([\\x20\\x21\\x23-\\x5b\\x5d-\\x7e]|\\\\([\\\\bftrn\"]|x[\\p{XDigit}]{2}))*\"");
    public static final Pattern HEXBYTES_PATTERN = Pattern.compile("([\\p{XDigit}]{2}){1,}");

    protected AbstractKVCommand(String spec) {
        super(spec);
    }

    @Override
    protected Parser<?> getParser(String typeName) {
        if ("bytes".equals(typeName)) {
            return new BytesParser();
        }
        return super.getParser(typeName);
    }

    public static String toCString(byte[] data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"null data");
        StringBuilder buf = new StringBuilder(data.length + 4);
        buf.append('\"');
        block8: for (byte b : data) {
            int ch = b & 0xFF;
            switch (ch) {
                case 34: 
                case 92: {
                    buf.append('\\').append((char)ch);
                    continue block8;
                }
                case 8: {
                    buf.append('\\').append('b');
                    continue block8;
                }
                case 12: {
                    buf.append('\\').append('f');
                    continue block8;
                }
                case 9: {
                    buf.append('\\').append('t');
                    continue block8;
                }
                case 10: {
                    buf.append('\\').append('n');
                    continue block8;
                }
                case 13: {
                    buf.append('\\').append('r');
                    continue block8;
                }
                default: {
                    if (ch >= 32 && ch <= 126) {
                        buf.append((char)ch);
                        continue block8;
                    }
                    buf.append('\\');
                    buf.append('x');
                    buf.append(Character.forDigit(ch >> 4, 16));
                    buf.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static byte[] fromCString(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"null string");
        Preconditions.checkArgument((string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' ? 1 : 0) != 0, (Object)"string is not contained in double quotes");
        string = string.substring(1, string.length() - 1);
        byte[] buf = new byte[string.length()];
        int index = 0;
        block9: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch != '\\') {
                Preconditions.checkArgument((ch >= ' ' && ch <= '~' ? 1 : 0) != 0, (Object)String.format("illegal character 0x%02x in encoded string", ch & 0xFF));
                buf[index++] = (byte)ch;
                continue;
            }
            Preconditions.checkArgument((++i < string.length() ? 1 : 0) != 0, (Object)"illegal trailing '\\' in encoded string");
            ch = string.charAt(i);
            switch (ch) {
                case '\"': {
                    buf[index++] = 34;
                    continue block9;
                }
                case '\\': {
                    buf[index++] = 92;
                    continue block9;
                }
                case 'b': {
                    buf[index++] = 8;
                    continue block9;
                }
                case 't': {
                    buf[index++] = 9;
                    continue block9;
                }
                case 'n': {
                    buf[index++] = 10;
                    continue block9;
                }
                case 'f': {
                    buf[index++] = 12;
                    continue block9;
                }
                case 'r': {
                    buf[index++] = 13;
                    continue block9;
                }
                default: {
                    Preconditions.checkArgument((ch == 'x' ? 1 : 0) != 0, (Object)("illegal escape sequence '\\" + ch + "' in encoded string"));
                    Preconditions.checkArgument((i + 2 < string.length() ? 1 : 0) != 0, (Object)"illegal truncated '\\x' escape sequence in encoded string");
                    int value = 0;
                    for (int j = 0; j < 2; ++j) {
                        int nibble;
                        Preconditions.checkArgument(((nibble = Character.digit(string.charAt(++i), 16)) != -1 ? 1 : 0) != 0, (Object)("illegal escape sequence '" + string.substring(i - j - 2, i - j + 2) + "' in encoded string"));
                        assert (nibble >= 0 && nibble <= 15);
                        value = value << 4 | nibble;
                    }
                    buf[index++] = (byte)value;
                }
            }
        }
        if (index < buf.length) {
            byte[] newbuf = new byte[index];
            System.arraycopy(buf, 0, newbuf, 0, index);
            buf = newbuf;
        }
        return buf;
    }

    private static class BytesParser
    implements Parser<byte[]> {
        private BytesParser() {
        }

        public byte[] parse(ParseSession session, ParseContext ctx, boolean complete) {
            Matcher cstringMatcher = ctx.tryPattern(CSTRING_PATTERN);
            if (cstringMatcher != null) {
                return AbstractKVCommand.fromCString(cstringMatcher.group());
            }
            Matcher hexbytesMatcher = ctx.tryPattern(HEXBYTES_PATTERN);
            if (hexbytesMatcher != null) {
                return ByteUtil.parse((String)hexbytesMatcher.group());
            }
            throw new ParseException(ctx, "invalid byte array value");
        }
    }
}

