/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import org.jsimpledb.JSimpleDB;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.core.Schema;
import org.jsimpledb.core.SchemaMismatchException;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.schema.SchemaModel;

abstract class AbstractSchemaCommand
extends AbstractCommand {
    AbstractSchemaCommand(String spec) {
        super(spec);
    }

    protected static SchemaModel getSchemaModel(CliSession session, int version) {
        if (version == 0) {
            JSimpleDB jdb;
            SchemaModel schemaModel = session.getSchemaModel();
            if (schemaModel == null && (jdb = session.getJSimpleDB()) != null) {
                schemaModel = jdb.getSchemaModel();
            }
            if (schemaModel == null) {
                session.getWriter().println("No schema configured on this session");
                return null;
            }
            return schemaModel;
        }
        return AbstractSchemaCommand.runWithoutSchema(session, (session1, tx) -> {
            Schema schema = (Schema)tx.getSchemas().getVersions().get(version);
            if (schema == null) {
                session1.getWriter().println("Schema version " + version + " not found (known versions: " + tx.getSchemas().getVersions().keySet() + ")");
                return null;
            }
            return schema.getSchemaModel();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <R> R runWithoutSchema(CliSession session, SchemaAgnosticAction<R> action) {
        Transaction tx;
        try {
            tx = session.getDatabase().createTransaction(null, 0, false);
        }
        catch (SchemaMismatchException e) {
            session.getWriter().println("Database is uninitialized");
            return null;
        }
        boolean success = false;
        try {
            R result = action.runWithoutSchema(session, tx);
            tx.commit();
            success = true;
            R r = result;
            return r;
        }
        finally {
            if (!success) {
                tx.rollback();
            }
        }
    }

    protected static interface SchemaAgnosticAction<R> {
        public R runWithoutSchema(CliSession var1, Transaction var2);
    }
}

