/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import java.util.EnumSet;
import java.util.Map;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.cli.cmd.Command;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.util.ParseContext;

public class RegisterCommandCommand
extends AbstractCommand {
    public RegisterCommandCommand() {
        super("register-command class:expr");
    }

    @Override
    public String getHelpSummary() {
        return "Instantiates a user-supplied class implementing the Command interface and registers it as an available command.";
    }

    @Override
    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    @Override
    public CliSession.Action getAction(CliSession session0, ParseContext ctx, boolean complete, Map<String, Object> params) {
        Node expr = (Node)params.get("class");
        return session -> {
            Class commandClass = this.getExprParam(session, expr, "class", (Object obj) -> {
                if (!(obj instanceof Class)) {
                    throw new IllegalArgumentException("not a " + Class.class.getName() + " instance");
                }
                Class cl = (Class)obj;
                if (!Command.class.isAssignableFrom(cl)) {
                    throw new IllegalArgumentException(cl + " does not implement " + Command.class);
                }
                return cl.asSubclass(Command.class);
            });
            Command command = (Command)commandClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            session.registerCommand(command);
            session.getWriter().println("Registered command `" + command.getName() + "'");
        };
    }
}

