/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.cli.cmd;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.dellroad.stuff.io.AtomicUpdateFileOutputStream;
import org.dellroad.stuff.xml.IndentXMLStreamWriter;
import org.jsimpledb.JObject;
import org.jsimpledb.Session;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.util.XMLObjectSerializer;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.util.ParseCastFunction;
import org.jsimpledb.util.ParseContext;

public class SaveCommand
extends AbstractCommand {
    public SaveCommand() {
        super("save --storage-id-format:storageIdFormat -w:weak file.xml:file expr:expr");
    }

    @Override
    public String getHelpSummary() {
        return "Exports objects to an XML file";
    }

    @Override
    public String getHelpDetail() {
        return "Evaluates the expression, which must evaluate to an Iterator (or Iterable) of database objects, and writes the objects to the specified XML file. Objects can be read back in later via `load'.\nIf the `-w' flag is given, for certain key/value stores a weaker consistency level is used for the tranasction to reduce the chance of conflicts.";
    }

    @Override
    protected Parser<?> getParser(String typeName) {
        return "file".equals(typeName) ? new Parser() : super.getParser(typeName);
    }

    @Override
    public CliSession.Action getAction(CliSession session, ParseContext ctx, boolean complete, Map<String, Object> params) {
        boolean nameFormat = !params.containsKey("storageIdFormat");
        boolean weak = params.containsKey("weak");
        File file = (File)params.get("file.xml");
        Node expr = (Node)params.get("expr");
        return new SaveAction(nameFormat, weak, file, expr);
    }

    private static class SaveAction
    implements CliSession.Action,
    Session.RetryableAction,
    Session.HasTransactionOptions {
        private final boolean nameFormat;
        private final boolean weak;
        private final File file;
        private final Node expr;

        SaveAction(boolean nameFormat, boolean weak, File file, Node expr) {
            this.nameFormat = nameFormat;
            this.weak = weak;
            this.file = file;
            this.expr = expr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(CliSession session) throws Exception {
            int count;
            Value value = this.expr.evaluate((ParseSession)session);
            Iterable i = (Iterable)value.checkType((ParseSession)session, "save", Iterable.class);
            Object updateOutput = !this.isWindows() ? new AtomicUpdateFileOutputStream(this.file) : new FileOutputStream(this.file);
            BufferedOutputStream output = new BufferedOutputStream((OutputStream)updateOutput);
            boolean success = false;
            try {
                IndentXMLStreamWriter writer = new IndentXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(output, "UTF-8"));
                writer.writeStartDocument("UTF-8", "1.0");
                count = new XMLObjectSerializer(session.getTransaction()).write((XMLStreamWriter)writer, this.nameFormat, Iterables.transform((Iterable)i, (Function)new ParseCastFunction<ObjId>(ObjId.class){

                    public ObjId apply(Object obj) {
                        return obj instanceof JObject ? ((JObject)obj).getObjId() : (ObjId)super.apply(obj);
                    }
                }.toGuava()));
                success = true;
            }
            finally {
                if (success) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                } else if (updateOutput instanceof AtomicUpdateFileOutputStream) {
                    updateOutput.cancel();
                }
            }
            session.getWriter().println("Wrote " + count + " objects to `" + this.file + "'");
        }

        public Map<String, ?> getTransactionOptions() {
            return this.weak ? Collections.singletonMap("consistency", "EVENTUAL") : null;
        }

        private boolean isWindows() {
            return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("win");
        }
    }
}

