/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.async;

import com.foundationdb.Disposable;
import com.foundationdb.async.Function;
import com.foundationdb.async.Future;
import com.foundationdb.async.PartialFunction;
import com.foundationdb.async.PartialFuture;
import com.foundationdb.async.SettableFuture;
import com.foundationdb.async.SettablePartialFuture;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public abstract class AbstractPartialFuture<T>
implements Disposable,
PartialFuture<T> {
    private boolean isCallbackRegistered = false;
    private boolean hasFired = false;
    private LinkedList<Runnable> runnables;
    private final Executor executor;

    public AbstractPartialFuture(Executor executor) {
        this.executor = executor;
    }

    @Deprecated
    public AbstractPartialFuture(long l, Executor executor) {
        if (l != 0L) {
            throw new IllegalArgumentException("Cannot construct with pointer");
        }
        this.executor = executor;
    }

    protected abstract void registerSingleCallback(Runnable var1);

    protected abstract T getIfDone() throws Exception;

    private boolean setupCallback() {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException("called without external synchronization");
        }
        if (this.isCallbackRegistered) {
            return this.hasFired;
        }
        this.runnables = new LinkedList();
        this.registerSingleCallback(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractPartialFuture abstractPartialFuture = AbstractPartialFuture.this;
                synchronized (abstractPartialFuture) {
                    if (!AbstractPartialFuture.this.isCallbackRegistered) {
                        AbstractPartialFuture.this.hasFired = true;
                        return;
                    }
                }
                AbstractPartialFuture.this.executeCallbacks();
            }
        });
        this.isCallbackRegistered = true;
        return this.hasFired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCallbacks() {
        LinkedList<Runnable> linkedList;
        AbstractPartialFuture abstractPartialFuture = this;
        synchronized (abstractPartialFuture) {
            linkedList = this.runnables;
            this.runnables = null;
            this.hasFired = true;
        }
        for (Runnable runnable : linkedList) {
            this.executor.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReady(final Runnable runnable) {
        boolean bl = false;
        AbstractPartialFuture abstractPartialFuture = this;
        synchronized (abstractPartialFuture) {
            if (this.setupCallback()) {
                bl = true;
            } else {
                this.runnables.add(runnable);
            }
        }
        if (bl) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onReadyAlready(Runnable runnable) {
        AbstractPartialFuture abstractPartialFuture = this;
        synchronized (abstractPartialFuture) {
            if (this.setupCallback()) {
                return true;
            }
            this.runnables.add(runnable);
            return false;
        }
    }

    @Override
    public <V> PartialFuture<V> flatMap(final PartialFunction<? super T, ? extends PartialFuture<V>> partialFunction) {
        final SettablePartialFuture settablePartialFuture = new SettablePartialFuture(this.getExecutor());
        this.onReady(new Runnable(){

            @Override
            public void run() {
                PartialFuture partialFuture;
                try {
                    partialFuture = (PartialFuture)partialFunction.apply(AbstractPartialFuture.this.get());
                }
                catch (Exception exception) {
                    settablePartialFuture.setError(exception);
                    return;
                }
                catch (Error error) {
                    settablePartialFuture.setError(error);
                    throw error;
                }
                partialFuture.onReady(new Runnable(){

                    @Override
                    public void run() {
                        Object t;
                        try {
                            t = partialFuture.get();
                        }
                        catch (Exception exception) {
                            settablePartialFuture.setError(exception);
                            return;
                        }
                        catch (Error error) {
                            settablePartialFuture.setError(error);
                            throw error;
                        }
                        settablePartialFuture.set(t);
                    }
                });
                settablePartialFuture.onCancelledCancel(partialFuture);
            }
        });
        settablePartialFuture.onCancelledCancel(this);
        return settablePartialFuture;
    }

    @Override
    public <V> PartialFuture<V> map(final PartialFunction<? super T, V> partialFunction) {
        final SettablePartialFuture settablePartialFuture = new SettablePartialFuture(this.getExecutor());
        this.onReady(new Runnable(){

            @Override
            public void run() {
                Object v;
                try {
                    v = partialFunction.apply(AbstractPartialFuture.this.get());
                }
                catch (Exception exception) {
                    settablePartialFuture.setError(exception);
                    return;
                }
                catch (Error error) {
                    settablePartialFuture.setError(error);
                    throw error;
                }
                settablePartialFuture.set(v);
            }
        });
        settablePartialFuture.onCancelledCancel(this);
        return settablePartialFuture;
    }

    @Override
    public Future<T> rescue(final Function<? super Exception, Future<T>> function) {
        final SettableFuture settableFuture = new SettableFuture(this.getExecutor());
        this.onReady(new Runnable(){

            @Override
            public void run() {
                Object t;
                try {
                    t = AbstractPartialFuture.this.get();
                }
                catch (Error error) {
                    settableFuture.setError(error);
                    throw error;
                }
                catch (Exception exception) {
                    Future future;
                    try {
                        future = (Future)function.apply(exception);
                    }
                    catch (RuntimeException runtimeException) {
                        settableFuture.setError(runtimeException);
                        return;
                    }
                    catch (Error error) {
                        settableFuture.setError(error);
                        throw error;
                    }
                    future.onReady(new Runnable(){

                        @Override
                        public void run() {
                            Object t;
                            try {
                                t = future.get();
                            }
                            catch (RuntimeException runtimeException) {
                                settableFuture.setError(runtimeException);
                                return;
                            }
                            catch (Error error) {
                                settableFuture.setError(error);
                                throw error;
                            }
                            settableFuture.set(t);
                        }
                    });
                    settableFuture.onCancelledCancel(future);
                    return;
                }
                settableFuture.set(t);
            }
        });
        settableFuture.onCancelledCancel(this);
        return settableFuture;
    }

    @Override
    public PartialFuture<T> rescue(final PartialFunction<? super Exception, ? extends PartialFuture<T>> partialFunction) {
        final SettablePartialFuture settablePartialFuture = new SettablePartialFuture(this.getExecutor());
        this.onReady(new Runnable(){

            @Override
            public void run() {
                Object t;
                try {
                    t = AbstractPartialFuture.this.get();
                }
                catch (Error error) {
                    settablePartialFuture.setError(error);
                    throw error;
                }
                catch (Exception exception) {
                    PartialFuture partialFuture;
                    try {
                        partialFuture = (PartialFuture)partialFunction.apply(exception);
                    }
                    catch (Exception exception2) {
                        settablePartialFuture.setError(exception2);
                        return;
                    }
                    catch (Error error) {
                        settablePartialFuture.setError(error);
                        throw error;
                    }
                    partialFuture.onReady(new Runnable(){

                        @Override
                        public void run() {
                            Object t;
                            try {
                                t = partialFuture.get();
                            }
                            catch (Exception exception) {
                                settablePartialFuture.setError(exception);
                                return;
                            }
                            catch (Error error) {
                                settablePartialFuture.setError(error);
                                throw error;
                            }
                            settablePartialFuture.set(t);
                        }
                    });
                    settablePartialFuture.onCancelledCancel(partialFuture);
                    return;
                }
                settablePartialFuture.set(t);
            }
        });
        settablePartialFuture.onCancelledCancel(this);
        return settablePartialFuture;
    }

    @Override
    public T get() throws Exception {
        this.blockUntilReady();
        return this.getIfDone();
    }

    @Override
    public T getInterruptibly() throws Exception {
        this.blockInterruptibly();
        return this.getIfDone();
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    protected static final class SelfNotifier
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SelfNotifier selfNotifier = this;
            synchronized (selfNotifier) {
                this.notify();
            }
        }
    }
}

