/*
 * Decompiled with CFR 0.152.
 */
package com.foundationdb.subspace;

import com.foundationdb.Range;
import com.foundationdb.tuple.ByteArrayUtil;
import com.foundationdb.tuple.Tuple;
import java.util.Arrays;

public class Subspace {
    static final Tuple EMPTY_TUPLE = Tuple.from(new Object[0]);
    static final byte[] EMPTY_BYTES = new byte[0];
    private final byte[] rawPrefix;

    public Subspace() {
        this(EMPTY_TUPLE, EMPTY_BYTES);
    }

    public Subspace(Tuple tuple) {
        this(tuple, EMPTY_BYTES);
    }

    public Subspace(byte[] byArray) {
        this(EMPTY_TUPLE, byArray);
    }

    public Subspace(Tuple tuple, byte[] byArray) {
        this.rawPrefix = ByteArrayUtil.join(byArray, tuple.pack());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Subspace subspace = (Subspace)object;
        return Arrays.equals(this.rawPrefix, subspace.rawPrefix);
    }

    public String toString() {
        return "Subspace(rawPrefix=" + ByteArrayUtil.printable(this.rawPrefix) + ")";
    }

    public Subspace get(Object object) {
        return this.get(Tuple.from(object));
    }

    public Subspace get(Tuple tuple) {
        return this.subspace(tuple);
    }

    public byte[] getKey() {
        return this.pack();
    }

    public byte[] pack() {
        return Arrays.copyOf(this.rawPrefix, this.rawPrefix.length);
    }

    public byte[] pack(Object object) {
        return this.pack(Tuple.from(object));
    }

    public byte[] pack(Tuple tuple) {
        return ByteArrayUtil.join(this.rawPrefix, tuple.pack());
    }

    public Tuple unpack(byte[] byArray) {
        if (!this.contains(byArray)) {
            throw new IllegalArgumentException("Cannot unpack key that is not contained in subspace.");
        }
        return Tuple.fromBytes(Arrays.copyOfRange(byArray, this.rawPrefix.length, byArray.length));
    }

    public Range range() {
        return this.range(EMPTY_TUPLE);
    }

    public Range range(Tuple tuple) {
        Range range = tuple.range();
        return new Range(ByteArrayUtil.join(this.rawPrefix, range.begin), ByteArrayUtil.join(this.rawPrefix, range.end));
    }

    public boolean contains(byte[] byArray) {
        return ByteArrayUtil.startsWith(byArray, this.rawPrefix);
    }

    public Subspace subspace(Tuple tuple) {
        return new Subspace(tuple, this.rawPrefix);
    }
}

