/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import java.util.SortedMap;
import java.util.regex.Matcher;
import org.jsimpledb.core.CompositeIndex;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.parse.ObjTypeParser;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.util.ParseContext;

public class CompositeIndexParser
implements Parser<CompositeIndex> {
    private final SpaceParser spaceParser = new SpaceParser();

    @Override
    public CompositeIndex parse(ParseSession session, ParseContext ctx, boolean complete) {
        ObjType objType = new ObjTypeParser().parse(session, ctx, complete);
        ctx.skipWhitespace();
        if (!ctx.tryLiteral(".")) {
            throw new ParseException(ctx, "expected composite index name").addCompletion(".");
        }
        ctx.skipWhitespace();
        SortedMap indexMap = objType.getCompositeIndexesByName();
        Matcher nameMatcher = ctx.tryPattern("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
        if (nameMatcher == null) {
            throw new ParseException(ctx, "expected composite index name").addCompletions(indexMap.keySet());
        }
        String indexName = nameMatcher.group();
        CompositeIndex index = (CompositeIndex)indexMap.get(indexName);
        if (index == null) {
            throw new ParseException(ctx, "unknown composite index `" + indexName + "' on " + objType).addCompletions(ParseUtil.complete(indexMap.keySet(), indexName));
        }
        return index;
    }
}

