/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.dellroad.stuff.java.EnumUtil;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.util.ParseContext;

public class EnumNameParser<T extends Enum<T>>
implements Parser<T> {
    private final Class<T> type;
    private final Function<T, String> nameFunction;

    public EnumNameParser(Class<T> type) {
        this(type, true);
    }

    public EnumNameParser(Class<T> type, boolean lowerCase) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        this.type = type;
        this.nameFunction = value -> {
            String name = value.name();
            if (lowerCase) {
                name = name.toLowerCase();
            }
            return name;
        };
    }

    @Override
    public T parse(ParseSession session, ParseContext ctx, boolean complete) {
        Matcher matcher = ctx.tryPattern("[^\\s;]*");
        if (matcher == null) {
            ParseException e = new ParseException(ctx);
            if (ctx.isEOF() && complete) {
                e.addCompletions(EnumUtil.getValues(this.type).stream().map(this.nameFunction));
            }
            throw e;
        }
        String valueName = matcher.group();
        return (T)EnumUtil.getValues(this.type).stream().filter(value -> valueName.equals(this.nameFunction.apply((Enum)value))).findAny().orElseThrow(() -> new ParseException(ctx, "unknown value `" + valueName + "'").addCompletions(ParseUtil.complete(EnumUtil.getValues(this.type).stream().map(this.nameFunction), valueName)));
    }
}

