/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import com.google.common.base.Preconditions;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.util.ParseContext;

public class FieldTypeParser<T>
implements Parser<T> {
    private final FieldType<?> fieldType;
    private final String typeName;

    public FieldTypeParser(FieldType<?> fieldType) {
        this(fieldType, null);
        Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
    }

    private FieldTypeParser(FieldType<?> fieldType, String typeName) {
        this.fieldType = fieldType;
        this.typeName = typeName;
    }

    @Override
    public T parse(ParseSession session, ParseContext ctx, boolean complete) {
        FieldType actualFieldType;
        FieldType fieldType = actualFieldType = this.fieldType != null ? this.fieldType : session.getDatabase().getFieldTypeRegistry().getFieldType(this.typeName);
        if (actualFieldType == null) {
            throw new ParseException(ctx, "no known field type `" + this.typeName + "' registered with database");
        }
        try {
            return (T)actualFieldType.fromParseableString(ctx);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(ctx, "invalid " + actualFieldType.getName() + " parameter");
        }
    }

    public static FieldTypeParser<?> getFieldTypeParser(String typeName) {
        Preconditions.checkArgument((typeName != null ? 1 : 0) != 0, (Object)"null typeName");
        return new FieldTypeParser(null, typeName);
    }
}

