/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.Session;
import org.jsimpledb.core.Database;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.parse.func.Function;
import org.jsimpledb.util.ImplementationsReader;

public class ParseSession
extends Session {
    public static final String PARSE_FUNCTIONS_DESCRIPTOR_RESOURCE = "META-INF/jsimpledb/parse-function-implementations.xml";
    private static final HashMap<String, Class<?>> PRIMITIVE_CLASSES = new HashMap(9);
    private final LinkedHashSet<String> imports = new LinkedHashSet();
    private final TreeMap<String, Function> functions = new TreeMap();
    private final TreeMap<String, Value> variables = new TreeMap();
    private Parser<? extends Node> identifierParser;

    public ParseSession(KVDatabase kvdb) {
        super(kvdb);
        this.imports.add("java.lang.*");
    }

    public ParseSession(Database db) {
        super(db);
        this.imports.add("java.lang.*");
    }

    public ParseSession(JSimpleDB jdb) {
        super(jdb);
        this.imports.add("java.lang.*");
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public SortedMap<String, Function> getFunctions() {
        return this.functions;
    }

    public SortedMap<String, Value> getVars() {
        return this.variables;
    }

    public void loadFunctionsFromClasspath() {
        ImplementationsReader reader = new ImplementationsReader("parse-function");
        ArrayList<Object[]> paramLists = new ArrayList<Object[]>(2);
        paramLists.add(new Object[]{this});
        paramLists.add(new Object[0]);
        reader.setConstructorParameterLists(paramLists);
        reader.findImplementations(Function.class, PARSE_FUNCTIONS_DESCRIPTOR_RESOURCE).forEach(this::registerFunction);
    }

    public void registerFunction(Function function) {
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"null function");
        this.functions.put(function.getName(), function);
    }

    public Parser<? extends Node> getIdentifierParser() {
        return this.identifierParser;
    }

    public void setIdentifierParser(Parser<? extends Node> identifierParser) {
        this.identifierParser = identifierParser;
    }

    public Class<?> resolveClass(String name, boolean allowPrimitive) {
        int len;
        int dims = 0;
        for (len = name.length(); len > 2 && name.charAt(len - 2) == '[' && name.charAt(len - 1) == ']'; len -= 2) {
            ++dims;
        }
        String baseName = name.substring(0, len);
        int firstDot = baseName.indexOf(46);
        String firstPart = firstDot != -1 ? baseName.substring(0, firstDot) : baseName;
        ArrayList<String> packages = new ArrayList<String>(this.imports.size() + 1);
        packages.add(null);
        packages.addAll(this.imports);
        Class<?> baseClass = null;
        block4: for (String pkg : packages) {
            String className;
            if (pkg == null) {
                className = baseName;
            } else if (pkg.endsWith(".*")) {
                className = pkg.substring(0, pkg.length() - 1) + baseName;
            } else {
                int simpleNameStart = pkg.lastIndexOf(46) + 1;
                if (!firstPart.equals(pkg.substring(simpleNameStart))) continue;
                className = pkg.substring(0, simpleNameStart) + baseName.replaceAll("\\.", "\\$");
            }
            while (true) {
                try {
                    baseClass = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    break block4;
                }
                catch (ClassNotFoundException simpleNameStart) {
                }
                catch (StringIndexOutOfBoundsException simpleNameStart) {
                    // empty catch block
                }
                int lastDot = className.lastIndexOf(46);
                if (lastDot == -1) continue block4;
                className = className.substring(0, lastDot) + "$" + className.substring(lastDot + 1);
            }
        }
        if (baseClass == null && (allowPrimitive || dims > 0)) {
            baseClass = PRIMITIVE_CLASSES.get(baseName);
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("unknown class `" + name + "'");
        }
        return ParseUtil.getArrayClass(baseClass, dims);
    }

    public String relativizeClassName(Class<?> klass) {
        Preconditions.checkArgument((klass != null ? 1 : 0) != 0, (Object)"null klass");
        StringBuilder dims = new StringBuilder();
        while (klass.isArray()) {
            klass = klass.getComponentType();
            dims.append("[]");
        }
        String name = klass.getName();
        int pos = name.lastIndexOf(46);
        while (pos > 0) {
            String shortName = name.substring(pos + 1);
            try {
                if (this.resolveClass(shortName, false) == klass) {
                    return shortName + dims;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos = name.lastIndexOf(46, pos - 1);
        }
        return klass.getName() + dims;
    }

    public boolean performParseSessionAction(Action action) {
        return this.performSessionAction(this.wrap(action));
    }

    public boolean performParseSessionActionWithCurrentTransaction(Action action) {
        return this.performSessionActionWithCurrentTransaction(this.wrap(action));
    }

    private WrapperAction wrap(Action action) {
        return action instanceof Session.RetryableAction ? new RetryableWrapperAction(action) : (action instanceof Session.TransactionalAction ? new TransactionalWrapperAction(action) : new WrapperAction(action));
    }

    static {
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
    }

    @FunctionalInterface
    public static interface Action {
        public void run(ParseSession var1) throws Exception;
    }

    private static class RetryableWrapperAction
    extends TransactionalWrapperAction
    implements Session.RetryableAction {
        RetryableWrapperAction(Action action) {
            super(action);
        }
    }

    private static class TransactionalWrapperAction
    extends WrapperAction
    implements Session.TransactionalAction,
    Session.HasTransactionOptions {
        TransactionalWrapperAction(Action action) {
            super(action);
        }

        public Map<String, ?> getTransactionOptions() {
            return this.action instanceof Session.HasTransactionOptions ? ((Session.HasTransactionOptions)this.action).getTransactionOptions() : null;
        }
    }

    private static class WrapperAction
    implements Session.Action {
        protected final Action action;

        WrapperAction(Action action) {
            this.action = action;
        }

        public void run(Session session) throws Exception {
            this.action.run((ParseSession)session);
        }
    }
}

