/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Stream;
import org.dellroad.stuff.java.Primitive;
import org.jsimpledb.JClass;
import org.jsimpledb.JField;
import org.jsimpledb.core.Field;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.ObjType;
import org.jsimpledb.core.UnknownTypeException;
import org.jsimpledb.parse.ObjInfo;
import org.jsimpledb.parse.ParseSession;

public final class ParseUtil {
    public static final String IDENT_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";

    private ParseUtil() {
    }

    public static Stream<String> complete(Collection<String> choices, String prefix) {
        return ParseUtil.complete(choices.stream(), prefix);
    }

    public static Stream<String> complete(Stream<String> choices, String prefix) {
        return choices.filter(choice -> choice.startsWith(prefix)).map(choice -> choice.substring(prefix.length()));
    }

    public static JField resolveJField(ParseSession session, ObjId id, String name) {
        JClass jclass;
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((boolean)session.getMode().hasJSimpleDB(), (Object)"session mode has no JSimpleDB");
        ObjInfo info = ObjInfo.getObjInfo(session, id);
        if (info == null) {
            throw new IllegalArgumentException("error accessing field `" + name + "': object " + id + " does not exist");
        }
        ObjType objType = info.getObjType();
        try {
            jclass = session.getJSimpleDB().getJClass(objType.getStorageId());
        }
        catch (UnknownTypeException e) {
            throw new IllegalArgumentException("error accessing field `" + name + "': " + e.getMessage(), e);
        }
        JField jfield = (JField)jclass.getJFieldsByName().get(name);
        if (jfield == null) {
            throw new IllegalArgumentException("error accessing field `" + name + "': there is no such field in " + objType);
        }
        return jfield;
    }

    public static Field<?> resolveField(ParseSession session, ObjId id, String fieldName) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((fieldName != null ? 1 : 0) != 0, (Object)"null fieldName");
        ObjInfo info = ObjInfo.getObjInfo(session, id);
        if (info == null) {
            throw new IllegalArgumentException("error accessing field `" + fieldName + "': object " + id + " does not exist");
        }
        ObjType objType = info.getObjType();
        return objType.getFields().values().stream().filter(field -> field.getName().equals(fieldName)).findAny().orElseThrow(() -> new IllegalArgumentException("error accessing field `" + fieldName + "': there is no such field in " + objType));
    }

    public static Class<?> getArrayClass(Class<?> base, int dims) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"null base");
        Preconditions.checkArgument((!base.isArray() ? 1 : 0) != 0, (Object)"base is array type");
        Preconditions.checkArgument((dims >= 0 && dims <= 255 ? 1 : 0) != 0, (Object)("invalid number of array dimensions (" + dims + ")"));
        Preconditions.checkArgument((base != Void.TYPE || dims == 0 ? 1 : 0) != 0, (Object)"invalid void array");
        if (dims == 0) {
            return base;
        }
        String suffix = base.isPrimitive() ? "" + Primitive.get(base).getLetter() : "L" + base.getName() + ";";
        StringBuilder buf = new StringBuilder(dims + suffix.length());
        while (dims-- > 0) {
            buf.append('[');
        }
        buf.append(suffix);
        String className = buf.toString();
        try {
            return Class.forName(className, false, base.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("error loading array class `" + className + "'");
        }
    }
}

