/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Node;

abstract class AbstractArrayNode
implements Node {
    protected final ClassNode baseTypeNode;
    protected final int numDimensions;

    protected AbstractArrayNode(ClassNode baseTypeNode, int numDimensions) {
        this.baseTypeNode = baseTypeNode;
        this.numDimensions = numDimensions;
    }

    protected Class<?> getBaseType(ParseSession session) {
        Class<?> baseType = this.baseTypeNode.resolveClass(session);
        if (baseType == Void.TYPE) {
            throw new EvalException("illegal instantiation of void array");
        }
        return baseType;
    }

    @Override
    public Class<?> getType(ParseSession session) {
        try {
            return ParseUtil.getArrayClass(this.getBaseType(session), this.numDimensions);
        }
        catch (EvalException e) {
            return Object.class;
        }
    }
}

