/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.List;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.TypeInferringNode;

abstract class AbstractInvokeNode<T extends Executable>
implements Node {
    final List<Node> paramNodes;

    protected AbstractInvokeNode(List<Node> paramNodes) {
        Preconditions.checkArgument((paramNodes != null ? 1 : 0) != 0, (Object)"null paramNodes");
        for (Node paramNode : paramNodes) {
            Preconditions.checkArgument((paramNode != null ? 1 : 0) != 0, (Object)"null paramNode in list");
        }
        this.paramNodes = paramNodes;
    }

    protected ParamInfo evaluateParams(ParseSession session) {
        Object[] params = new Object[this.paramNodes.size()];
        Type[] paramTypes = new Type[this.paramNodes.size()];
        for (int i = 0; i < params.length; ++i) {
            Node paramNode = this.paramNodes.get(i);
            if (paramNode instanceof TypeInferringNode) {
                paramTypes[i] = MethodUtil.FunctionalType.class;
                continue;
            }
            params[i] = paramNode.evaluate(session).get(session);
            paramTypes[i] = params[i] == null ? MethodUtil.NullType.class : params[i].getClass();
        }
        return new ParamInfo(params, paramTypes);
    }

    protected void fixupVarArgs(ParamInfo paramInfo, T executable) {
        if (!((Executable)executable).isVarArgs()) {
            return;
        }
        Object[] params = paramInfo.getParams();
        Class<?>[] formalTypes = ((Executable)executable).getParameterTypes();
        Class<?> lastFormalType = formalTypes[formalTypes.length - 1];
        Class<?> lastFormalElemType = lastFormalType.getComponentType();
        if (params.length == formalTypes.length) {
            Object lastParam = params[params.length - 1];
            Type lastParamType = paramInfo.getParamTypes()[params.length - 1];
            boolean canVarargs = MethodUtil.isCompatibleMethodParam(lastFormalElemType, lastParamType);
            if (!canVarargs) {
                return;
            }
            boolean canNormal = MethodUtil.isCompatibleMethodParam(lastFormalType, lastParamType);
            if (canNormal) {
                return;
            }
        }
        int offset = formalTypes.length - 1;
        int numVarargs = params.length - offset;
        Object varargs = Array.newInstance(lastFormalElemType, numVarargs);
        for (int i = 0; i < numVarargs; ++i) {
            try {
                Array.set(varargs, i, params[offset + i]);
                continue;
            }
            catch (Exception e) {
                throw new EvalException("invalid varargs parameter #" + (offset + i + 1) + " to " + executable, e);
            }
        }
        Object[] newParams = new Object[formalTypes.length];
        System.arraycopy(params, 0, newParams, 0, formalTypes.length - 1);
        newParams[formalTypes.length - 1] = varargs;
        paramInfo.setParams(newParams);
        paramInfo.setVarArgs(true);
    }

    protected void fixupTypeInferringNodes(ParseSession session, ParamInfo paramInfo, T executable) {
        Object[] params = paramInfo.getParams();
        Class<?>[] formalTypes = ((Executable)executable).getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Node paramNode;
            if (i == params.length - 1 && paramInfo.isVarArgs()) {
                Class<?> lastFormalElemType = formalTypes[formalTypes.length - 1].getComponentType();
                Object varargs = params[i];
                int numVarargs = Array.getLength(varargs);
                for (int j = 0; j < numVarargs; ++j) {
                    Node node = this.paramNodes.get(i + j);
                    if (!(node instanceof TypeInferringNode)) continue;
                    assert (Array.get(varargs, j) == null);
                    try {
                        Array.set(varargs, j, this.resolveAndEvaluate(session, (TypeInferringNode)node, lastFormalElemType));
                        continue;
                    }
                    catch (Exception e) {
                        throw new EvalException("invalid varargs parameter #" + (i + j + 1) + " to " + executable, e);
                    }
                }
            }
            if (i >= this.paramNodes.size() || !((paramNode = this.paramNodes.get(i)) instanceof TypeInferringNode)) continue;
            assert (params[i] == null);
            params[i] = this.resolveAndEvaluate(session, (TypeInferringNode)paramNode, formalTypes[i]);
        }
    }

    private Object resolveAndEvaluate(ParseSession session, TypeInferringNode node, Class<?> type) {
        return node.resolve(session, TypeToken.of(type)).evaluate(session).get(session);
    }

    static class ParamInfo {
        private Object[] params;
        private Type[] paramTypes;
        private boolean varargs;

        ParamInfo(Object[] params, Type[] paramTypes) {
            this.params = params;
            this.paramTypes = paramTypes;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }

        public Type[] getParamTypes() {
            return this.paramTypes;
        }

        public void setParamTypes(Type[] paramTypes) {
            this.paramTypes = paramTypes;
        }

        public boolean isVarArgs() {
            return this.varargs;
        }

        public void setVarArgs(boolean varargs) {
            this.varargs = varargs;
        }
    }
}

