/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public abstract class AbstractNamed {
    protected final String name;

    protected AbstractNamed(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        if (!Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*").matcher(name).matches()) {
            throw new IllegalArgumentException("invalid identifier `" + name + "'");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractNamed that = (AbstractNamed)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

