/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import org.jsimpledb.JField;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SimpleField;
import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.ParseUtil;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.AtomExprParser;
import org.jsimpledb.parse.expr.BeanPropertyValue;
import org.jsimpledb.parse.expr.BoundMethodReferenceNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.ExprParser;
import org.jsimpledb.parse.expr.FieldValue;
import org.jsimpledb.parse.expr.InstanceFieldValue;
import org.jsimpledb.parse.expr.JFieldValue;
import org.jsimpledb.parse.expr.JSimpleFieldValue;
import org.jsimpledb.parse.expr.MethodInvokeNode;
import org.jsimpledb.parse.expr.MethodUtil;
import org.jsimpledb.parse.expr.MutableBeanPropertyValue;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Op;
import org.jsimpledb.parse.expr.SimpleFieldValue;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.ParseContext;

public class BaseExprParser
implements Parser<Node> {
    public static final BaseExprParser INSTANCE = new BaseExprParser();
    private final SpaceParser spaceParser = new SpaceParser();

    @Override
    public Node parse(ParseSession session, ParseContext ctx, boolean complete) {
        Node node = AtomExprParser.INSTANCE.parse(session, ctx, complete);
        while (true) {
            Matcher propertyPrefixMatch;
            ctx.skipWhitespace();
            if (ctx.tryLiteral("[")) {
                this.spaceParser.parse(ctx, complete);
                final Node index = ExprParser.INSTANCE.parse(session, ctx, complete);
                this.spaceParser.parse(ctx, complete);
                if (!ctx.tryLiteral("]")) {
                    throw new ParseException(ctx).addCompletion("]");
                }
                final Node target = node;
                node = new Node(){

                    @Override
                    public Value evaluate(ParseSession session) {
                        return Op.ARRAY_ACCESS.apply(session, target.evaluate(session), index.evaluate(session));
                    }

                    @Override
                    public Class<?> getType(ParseSession session) {
                        Class<?> arrayType = target.getType(session);
                        return arrayType.isArray() ? arrayType.getComponentType() : Object.class;
                    }
                };
                continue;
            }
            if (ctx.tryLiteral("::")) {
                ctx.skipWhitespace();
                Matcher methodMatch = ctx.tryPattern("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
                if (methodMatch == null) {
                    throw new ParseException(ctx, "expected method name");
                }
                node = new BoundMethodReferenceNode(node, methodMatch.group());
                continue;
            }
            if (complete && (propertyPrefixMatch = ctx.tryPattern("\\.\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)?$")) != null) {
                String prefix = propertyPrefixMatch.group(1);
                if (prefix == null) {
                    prefix = "";
                }
                throw new ParseException(ctx).addCompletions(AtomExprParser.getInstanceMemberCompletions(node.getType(session), prefix));
            }
            Matcher invokeMatch = ctx.tryPattern("\\.\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*\\(");
            if (invokeMatch != null) {
                node = new MethodInvokeNode(node, invokeMatch.group(1), AtomExprParser.parseParams(session, ctx, complete));
                continue;
            }
            Matcher propertyMatch = ctx.tryPattern("\\.\\s*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*");
            if (propertyMatch != null) {
                final String propertyName = propertyMatch.group(1);
                final Node target = node;
                node = new Node(){

                    @Override
                    public Value evaluate(ParseSession session) {
                        return BaseExprParser.this.evaluateProperty(session, target.evaluate(session), propertyName);
                    }

                    @Override
                    public Class<?> getType(ParseSession session) {
                        return BaseExprParser.this.getPropertyType(session, target, propertyName);
                    }
                };
                continue;
            }
            if (ctx.tryLiteral("++")) {
                node = this.createPostcrementNode("increment", node, true);
                continue;
            }
            if (!ctx.tryLiteral("--")) break;
            node = this.createPostcrementNode("decrement", node, false);
        }
        return node;
    }

    private Value evaluateProperty(ParseSession session, Value value, String name) {
        Field javaField;
        BeanInfo beanInfo;
        Object target = value.checkNotNull(session, "property `" + name + "' access");
        Class<?> cl = target.getClass();
        if (session.getMode().hasJSimpleDB() && target instanceof JObject) {
            JField jfield0;
            JObject jobj = (JObject)target;
            ObjId id = jobj.getObjId();
            try {
                jfield0 = ParseUtil.resolveJField(session, id, name);
            }
            catch (IllegalArgumentException e) {
                jfield0 = null;
            }
            JField jfield = jfield0;
            if (jfield instanceof JSimpleField) {
                return new JSimpleFieldValue(jobj, (JSimpleField)jfield);
            }
            if (jfield != null) {
                return new JFieldValue(jobj, jfield);
            }
        } else if (session.getMode().hasCoreAPI() && target instanceof ObjId) {
            org.jsimpledb.core.Field<?> field0;
            ObjId id = (ObjId)target;
            try {
                field0 = ParseUtil.resolveField(session, id, name);
            }
            catch (IllegalArgumentException e) {
                field0 = null;
            }
            org.jsimpledb.core.Field<?> field = field0;
            if (field instanceof SimpleField) {
                return new SimpleFieldValue(id, (SimpleField)field);
            }
            if (field != null) {
                return new FieldValue(id, field);
            }
        }
        try {
            beanInfo = Introspector.getBeanInfo(cl);
        }
        catch (IntrospectionException e) {
            throw new EvalException("error introspecting class `" + cl.getName() + "': " + e, e);
        }
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            Method setter;
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || !propertyDescriptor.getName().equals(name)) continue;
            Method getter = propertyDescriptor.getReadMethod() != null ? MethodUtil.makeAccessible(propertyDescriptor.getReadMethod()) : null;
            Method method = setter = propertyDescriptor.getWriteMethod() != null ? MethodUtil.makeAccessible(propertyDescriptor.getWriteMethod()) : null;
            if (getter != null && setter != null) {
                return new MutableBeanPropertyValue(target, propertyDescriptor.getName(), getter, setter);
            }
            if (getter == null) continue;
            return new BeanPropertyValue(target, propertyDescriptor.getName(), getter);
        }
        try {
            javaField = AtomExprParser.findField(cl, name, false);
        }
        catch (NoSuchFieldException e) {
            javaField = null;
        }
        if (javaField != null) {
            return new InstanceFieldValue(target, javaField);
        }
        if (target.getClass().isArray() && name.equals("length")) {
            return new ConstValue(Array.getLength(target));
        }
        throw new EvalException("property `" + name + "' not found in " + cl);
    }

    private Class<?> getPropertyType(ParseSession session, Node node, String name) {
        Field javaField;
        BeanInfo beanInfo;
        Class<?> cl = node.getType(session);
        try {
            beanInfo = Introspector.getBeanInfo(cl);
        }
        catch (IntrospectionException e) {
            return Object.class;
        }
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (propertyDescriptor instanceof IndexedPropertyDescriptor || !propertyDescriptor.getName().equals(name) || propertyDescriptor.getReadMethod() == null) continue;
            return propertyDescriptor.getReadMethod().getReturnType();
        }
        try {
            javaField = AtomExprParser.findField(cl, name, false);
        }
        catch (NoSuchFieldException e) {
            javaField = null;
        }
        if (javaField != null) {
            return javaField.getType();
        }
        if (cl.isArray() && name.equals("length")) {
            return Integer.class;
        }
        return Object.class;
    }

    private Node createPostcrementNode(final String operation, final Node node, final boolean increment) {
        return new Node(){

            @Override
            public Value evaluate(ParseSession session) {
                return node.evaluate(session).xxcrement(session, "post-" + operation, increment);
            }

            @Override
            public Class<?> getType(ParseSession session) {
                return node.getType(session);
            }
        };
    }
}

