/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.java.PrimitiveSwitch;
import org.dellroad.stuff.java.PrimitiveSwitchAdapter;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.ClassNode;
import org.jsimpledb.parse.expr.ConstValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.TypeInferringNode;
import org.jsimpledb.parse.expr.Value;

public class CastNode
implements Node {
    private final ClassNode typeNode;
    private final Node target;

    public CastNode(ClassNode typeNode, Node target) {
        Preconditions.checkArgument((typeNode != null ? 1 : 0) != 0, (Object)"null typeNode");
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"null target");
        this.typeNode = typeNode;
        this.target = target;
    }

    @Override
    public Class<?> getType(ParseSession session) {
        try {
            return this.typeNode.resolveClass(session);
        }
        catch (EvalException e) {
            return Object.class;
        }
    }

    @Override
    public Value evaluate(ParseSession session) {
        FieldType fieldType;
        Object obj;
        Class<?> type = this.typeNode.resolveClass(session);
        if (type == Void.TYPE) {
            throw new EvalException("illegal cast to void");
        }
        String typeName = this.typeNode.getClassName();
        if (this.target instanceof TypeInferringNode) {
            Node node = ((TypeInferringNode)this.target).resolve(session, TypeToken.of(type));
            obj = node.evaluate(session).get(session);
        } else {
            obj = this.target.evaluate(session).get(session);
        }
        if (obj == null) {
            if (type.isPrimitive()) {
                throw new EvalException("invalid cast of null value to " + typeName);
            }
            return new ConstValue(null);
        }
        if (obj instanceof String && type != String.class && session.getDatabase() != null && (fieldType = session.getDatabase().getFieldTypeRegistry().getFieldType(TypeToken.of(type))) != null) {
            try {
                return new ConstValue(fieldType.fromString((String)obj));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (type.isPrimitive()) {
            Primitive primitive = Primitive.forName((String)typeName);
            if (primitive == Primitive.BOOLEAN) {
                return new ConstValue(new ConstValue(obj).checkBoolean(session, "cast to " + typeName));
            }
            final Integer num = obj instanceof Character ? (Number)Integer.valueOf(((Character)obj).charValue()) : (Number)new ConstValue(obj).checkNumeric(session, "cast to " + typeName);
            return new ConstValue(primitive.visit((PrimitiveSwitch)new PrimitiveSwitchAdapter<Object>(){

                public Object caseByte() {
                    return num.byteValue();
                }

                public Object caseShort() {
                    return num.shortValue();
                }

                public Object caseInteger() {
                    return num.intValue();
                }

                public Object caseFloat() {
                    return Float.valueOf(num.floatValue());
                }

                public Object caseLong() {
                    return num.longValue();
                }

                public Object caseDouble() {
                    return num.doubleValue();
                }

                protected Object caseDefault() {
                    throw new RuntimeException("internal error");
                }
            }));
        }
        if (!type.isInstance(obj)) {
            throw new EvalException("can't cast object of type " + obj.getClass().getName() + " to " + typeName);
        }
        return new ConstValue(obj);
    }
}

