/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import org.jsimpledb.parse.ParseException;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.Parser;
import org.jsimpledb.parse.SpaceParser;
import org.jsimpledb.parse.expr.LogicalOrParser;
import org.jsimpledb.parse.expr.Node;
import org.jsimpledb.parse.expr.Value;
import org.jsimpledb.util.ParseContext;

public class ConditionalParser
implements Parser<Node> {
    public static final ConditionalParser INSTANCE = new ConditionalParser();
    private final SpaceParser spaceParser = new SpaceParser();

    @Override
    public Node parse(ParseSession session, ParseContext ctx, boolean complete) {
        final Node test = LogicalOrParser.INSTANCE.parse(session, ctx, complete);
        this.spaceParser.parse(ctx, complete);
        if (!ctx.tryLiteral("?")) {
            return test;
        }
        this.spaceParser.parse(ctx, complete);
        final Node ifTrue = LogicalOrParser.INSTANCE.parse(session, ctx, complete);
        this.spaceParser.parse(ctx, complete);
        if (!ctx.tryLiteral(":")) {
            throw new ParseException(ctx).addCompletion(": ");
        }
        this.spaceParser.parse(ctx, complete);
        final Node ifFalse = LogicalOrParser.INSTANCE.parse(session, ctx, complete);
        return new Node(){

            @Override
            public Value evaluate(ParseSession session) {
                return test.evaluate(session).checkBoolean(session, "conditional") ? ifTrue.evaluate(session) : ifFalse.evaluate(session);
            }

            @Override
            public Class<?> getType(ParseSession session) {
                Class<?> falseType;
                Class<?> trueType = ifTrue.getType(session);
                return trueType == (falseType = ifFalse.getType(session)) ? trueType : Object.class;
            }
        };
    }
}

