/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractFieldValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.Value;

public class InstanceFieldValue
extends AbstractFieldValue {
    protected final Object object;

    public InstanceFieldValue(Object object, Field field) {
        super(field);
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"null object");
        Preconditions.checkArgument(((field.getModifiers() & 8) == 0 ? 1 : 0) != 0, (Object)"field is static");
        this.object = object;
    }

    @Override
    public Object get(ParseSession session) {
        try {
            return this.field.get(this.object);
        }
        catch (Exception e) {
            throw new EvalException("error reading field `" + this.field.getName() + "' in object of type " + this.object.getClass().getName() + ": " + e, e);
        }
    }

    @Override
    public void set(ParseSession session, Value value) {
        Object obj = value.get(session);
        try {
            this.field.set(this.object, obj);
        }
        catch (Exception e) {
            throw new EvalException("error writing field `" + this.field.getName() + "' in object of type " + this.object.getClass().getName() + ": " + e, e);
        }
    }
}

