/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.parse.expr;

import com.google.common.base.Preconditions;
import org.jsimpledb.JField;
import org.jsimpledb.JObject;
import org.jsimpledb.parse.ParseSession;
import org.jsimpledb.parse.expr.AbstractValue;
import org.jsimpledb.parse.expr.EvalException;
import org.jsimpledb.parse.expr.MethodUtil;

public class JFieldValue
extends AbstractValue {
    protected final JObject jobj;
    protected final JField jfield;

    public JFieldValue(JObject jobj, JField jfield) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        Preconditions.checkArgument((jfield != null ? 1 : 0) != 0, (Object)"null jfield");
        this.jobj = jobj;
        this.jfield = jfield;
    }

    @Override
    public Object get(ParseSession session) {
        try {
            return this.jfield.getValue(MethodUtil.refresh(this.jobj));
        }
        catch (Exception e) {
            throw new EvalException("error reading field `" + this.jfield.getName() + "' from object " + this.jobj.getObjId() + ": " + (e.getMessage() != null ? e.getMessage() : e));
        }
    }

    @Override
    public Class<?> getType(ParseSession session) {
        return this.jfield.getGetter().getReturnType();
    }
}

